% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TNRS_synonyms.R
\name{TNRS_synonyms}
\alias{TNRS_synonyms}
\title{Get synonyms for a single species}
\usage{
TNRS_synonyms(
  taxonomic_name,
  source = "wcvp",
  skip_internet_check = FALSE,
  ...
)
}
\arguments{
\item{taxonomic_name}{Data.frame containing a single row and two columns: 1) Row number, 2) Taxonomic name to get synonyms of. Alternatively, a single name cane be supplied as a character string.}

\item{source}{Character. A single taxonomic source to use. Default is "wcvp". Options include "wfo", "wcvp", and "cact".}

\item{skip_internet_check}{Should the check for internet connectivity be skipped? Default is FALSE.}

\item{...}{Additional parameters passed to internal functions}
}
\value{
Dataframe containing synonyms and associated data for a single species.
}
\description{
Get synonyms for a single species
}
\note{
This function only handles a single source and a single taxonomic name at a time. This is by design.

wfo = World Flora Online, wcvp = World Checklist of Vascular Plants, cact = Cactaceae at Caryophyllales.org
}
\examples{
{

TNRS_synonyms(taxonomic_name = "Sabal palmetto",source =  "wfo")

}
}
