% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_rpart.R
\name{rpart_wrapper}
\alias{rpart_wrapper}
\title{rpart_wrapper}
\usage{
rpart_wrapper(
  response,
  response_type = NULL,
  covariates = NULL,
  tree_builder_parameters = NULL,
  prune = FALSE
)
}
\arguments{
\item{response}{Response variable to use in rpart model.}

\item{response_type}{Class of response variable.}

\item{covariates}{Covariates to use in rpart model.}

\item{tree_builder_parameters}{A named list of parameters to pass to rpart.
This includes all input parameters that rpart can take.}

\item{prune}{Logical variable indicating whether the tree shold be
pruned to the subtree with the smallest cross-validation error. Defaults to
FALSE.}
}
\value{
An object of class rpart.
}
\description{
A wrapper function to rpart.
}
\details{
This function provides a wrapper to rpart that provides a convenient
interface for specifying the response variable and covariates for the
rpart model. The user may indicate whether the tree should be pruned to
the size that yields the smallest cross-validation error. An rpart.object
is returned.
}
\examples{
## Generate example data containing response, treatment, and covariates
N <- 100
continuous_response = runif( min = 0, max = 20, n = N )
trt <- sample( c('Control','Experimental'), size = N, prob = c(0.4,0.6), replace = TRUE )
X1 <- runif( N, min = 0, max = 1 )
X2 <- runif( N, min = 0, max = 1 )
X3 <- sample( c(0,1), size = N, prob = c(0.2,0.8), replace = TRUE )
X4 <- sample( c('A','B','C'), size = N, prob = c(0.6,0.3,0.1), replace = TRUE )
covariates <- data.frame( trt )
names( covariates ) <- "trt"
covariates$X1 <- X1
covariates$X2 <- X2
covariates$X3 <- X3
covariates$X4 <- X4
## Fit an rpart model
ex1 <- rpart_wrapper( response = continuous_response, covariates = covariates )
ex1
}
\seealso{
\link[rpart]{rpart}, \link[rpart]{rpart.object},
\link[survival]{Surv}
}
