% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_data.R
\name{options}
\alias{options}
\title{Option list used in the \code{make_data()} function}
\arguments{
\item{optim}{String specifying the data calculated by the user defined Model function, e.g. 
one of \code{c("DEoptim", "LaplacesDemon")}.}

\item{ve}{String specifying the version of the process model. Must be one of \code{c("std", "fqr", "red", "oak")}.}

\item{steps}{Integer numeric vector specifying the timesteps to output. The process model 
will run \code{max(steps)} iterations and the output will contain 
\code{length(steps)} output times.}

\item{initial_mass_par}{Boolean specifying if the initial biomass used in the process model should be 
estimated as a parameter.}

\item{initial_mass}{The initial biomass to use for the process model, when \code{initial_mass_par} is set 
to \code{FALSE}.}

\item{species}{A vector of names of species.}

\item{photo}{A vector specifying the photosynthesis system used by the species. 
Must be either \code{c("c3", "c4")} for each species.}

\item{swc_online}{Boolean specifying if soil water content should be calculated online as part of the 
process model (\code{TRUE}) or if it is given as a forcing parameter. Currently not supported.}

\item{lc}{Boolean turning light competition simulation in the process model on/off. Currently not supported.}

\item{fire}{Boolean turning fire in the process model on/off. Currently not supported.}

\item{pe}{Boolean turning process error simulation on/off.}

\item{pe_scale}{The process error scaling factor.}
}
\description{
The options list handed to \code{make_data()}. It specifies the process model options. 
An example is provided by \code{standard_options}.
}
\details{
Options to be used in the \code{make_data()} function
}
