% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_functions.R
\name{boundary_kernel}
\alias{boundary_kernel}
\title{Boundary Kernel Function}
\usage{
boundary_kernel(t, r, iT, h, kernel_func)
}
\arguments{
\item{t}{An integer specifying the current time period for which the kernel weights are computed.}

\item{r}{An integer representing the reference time period.}

\item{iT}{An integer indicating the total number of time periods in the dataset.}

\item{h}{A numeric value representing the bandwidth parameter for the kernel function.}

\item{kernel_func}{A function representing the kernel used for weighting.}
}
\value{
A numeric scalar representing the boundary-adjusted kernel weight for the given time period.
}
\description{
This function computes boundary kernel weights for a given time period \eqn{t} within a dataset
of size \eqn{T}. It adjusts the kernel weights near the boundaries to account for edge effects,
ensuring that the weights sum to one.
}
\details{
The boundary kernel function adjusts kernel weights near the start and end of the dataset to mitigate
edge effects commonly encountered in kernel-based methods. The function performs the following steps:
\enumerate{
  \item Scales the difference between the current time \code{t} and reference time \code{r} by the
  product of total time periods \code{T} and bandwidth \code{h}.
  \item Applies the kernel function to the scaled difference and adjusts by the bandwidth.
  \item Determines if the current time period is within the lower or upper boundary regions based on
  \eqn{T_h = \lfloor T \times h \rfloor}.
  \item Computes the integral of the kernel function over the adjusted limits to ensure the weights
  sum to one in boundary regions.
}
}
\keyword{internal}
