#' Example dataframe in package Tendril.
#'
#' A dataset containing the minimal 4 columns required to produe a Tendril plot
#'
#' @format A data frame with 1000 rows and 4 variables:
#' \describe{
#'   \item{subjid}{The subject IDs}
#'   \item{treatment}{The two treatments causing the tendrils to bend right or left, respectively}
#'   \item{ae}{The names of the tendrils}
#'   \item{day}{The day of the event relative to the treatment start date}
#' }
"TendrilData"

#' Example object Tendril as generated by Tendril().
#'
#' The object contains the following 12 items:
#'
#' @format A list of 12 elements:
#' \describe{
#' \item{Tendril.res$data }{: Dataframe of orginal data and coordinates}
#' \item{Tendril.res$Terms }{: Column containing the name of the tendrils}
#' \item{Tendril.res$Unique.Subject.Identifier }{: Columns containing subject IDs}
#' \item{Tendril.res$Treat }{: Column containing the name of the treatments}
#' \item{Tendril.res$StartDay }{: Column containing the start days of the events}
#' \item{Tendril.res$Treatments }{: The names of the treatments causing the tendrils to bend}
#' \item{Tendril.res$AEfreqThreshold }{: The frequency threshold for the events to be included in the analysis}
#' \item{Tendril.res$Tag }{: A tag or comment associated with the analysis}
#' \item{Tendril.res$SubjList }{: A dataframe containing subject IDs and treatments}
#' \item{Tendril.res$SubjList.subject }{: The name of the column in SubjList containing the subjects IDs}
#' \item{Tendril.res$SubjList.treatment }{: The name of the columns in SubjList containing the treatments}
#' \item{Tendril.res$SubjList.dropoutday }{: The name of the column in SubjList containing the dropoutday}
#' \item{Tendril.res$rotation_vector }{: The rotation vector used for the tendril analysis}
#' \item{Tendril.res$compensate_imbalance }{: Boolean indicating whether the imbalance in the groups is compensated}
#' \item{Tendril.res$n.tot }{: A data frame of 2 variables for number of subjects in each treatment}
#' }
"Tendril.res"

#' Example object Tendril as generated by Tendril() and Tendril.perm().
#'
#' The object contains the following 15 items:
#'
#' @format A list of 15 elements:
#' \describe{
#' \item{Tendril.perm.res$data }{: Dataframe of orginal data and coordinates}
#' \item{Tendril.perm.res$Terms }{: Column containing the name of the tendrils}
#' \item{Tendril.perm.res$Unique.Subject.Identifier }{: Columns containing subject IDs}
#' \item{Tendril.perm.res$Treat }{: Column containing the name of the treatments}
#' \item{Tendril.perm.res$StartDay }{: Column containing the start days of the events}
#' \item{Tendril.perm.res$Treatments }{: The names of the treatments causing the tendrils to bend}
#' \item{Tendril.perm.res$AEfreqThreshold }{: The frequency threshold for the events to be included in the analysis}
#' \item{Tendril.perm.res$Tag }{: A tag or comment associated with the analysis}
#' \item{Tendril.perm.res$SubjList }{: A dataframe containing subject IDs and treatments}
#' \item{Tendril.perm.res$SubjList.subject }{: The name of the column in SubjList containing the subjects IDs}
#' \item{Tendril.perm.res$SubjList.treatment }{: The name of the columns in SubjList containing the treatments}
#' \item{Tendril.perm.res$n.tot }{: A data frame of 2 variables for number of subjects in each treatment}
#' \item{Tendril.perm.res$PermTerm }{: Name of the tendril used for the permutations}
#' \item{Tendril.perm.res$perm.data }{: A dataframe containing the permutation results}
#' \item{Tendril.perm.res$tendril.pi }{: A list of permutation percentile calculation results}
#' }
"Tendril.perm.res"


#' Example of SubjList in package Tendril.
#'
#' @format A data frame with 500 rows and 2 variables:
#' \describe{
#'   \item{subjid}{: The subject IDs}
#'   \item{treatment}{: The two treatments causing the tendrils to bend left or right}
#' }
"SubjList"

#' Example of Rotations in package Tendril.
#'
#' @format A numeric vector with 1000 number 3s:
"Rotations"
