% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate.R
\name{univariate}
\alias{univariate}
\title{Univariate Analysis Of Sexual Dimorphism}
\usage{
univariate(
  x,
  Pop = 1,
  type_anova = "II",
  interact_anova = TRUE,
  es_anova = "none",
  pairwise = FALSE,
  padjust = "none",
  ...,
  lower.tail = FALSE,
  CI = 0.95,
  digits = 4
)
}
\arguments{
\item{x}{A data frame containing summary statistics.}

\item{Pop}{Number of the column containing populations' names, Default: 1}

\item{type_anova}{type of ANOVA test "I","II" or "III", Default:"II".}

\item{interact_anova}{Logical; if TRUE calculates interaction effect,
Default: TRUE.}

\item{es_anova}{Type of effect size either "f2" for f squared,"eta2" for eta
squared, "omega2" for omega squared or "none", Default:"none".}

\item{pairwise}{Logical; if TRUE runs multiple pairwise comparisons on
different populations using \link{t_greene} Default: FALSE}

\item{padjust}{Method of p.value adjustment for multiple comparisons
following \link[stats]{p.adjust}  Default: "none".}

\item{...}{Additional arguments that could be passed to the \link{t_greene}
function}

\item{lower.tail}{Logical; if TRUE probabilities are `P[X <= x]`,
otherwise, `P[X > x]`., Default: FALSE}

\item{CI}{confidence interval coverage takes value from 0 to 1, Default: 0.95.}

\item{digits}{Number of significant digits, Default: 4}
}
\value{
ANOVA table.
}
\description{
Calculation and visualization of the differences in degree
sexual dimorphism between multiple populations using a modified one way
ANOVA and summary statistics as input
}
\details{
Data is entered as a data frame of summary statistics where
the column containing population names is chosen by position (first by
default), other columns of summary data should have specific names (case
sensitive) similar to \link{baboon.parms_df}
}
\examples{
#'
# See Tables 6 and 8 and from Fidler and Thompson (2001).
# The “eta2” and “omega2” CIs match those in Table 8.
# See “FT” dataset for Fidler and Thompson (2001) reference

# acquiring summary data
FT_sum <- extract_sum(FT, test = "uni", run = FALSE)
# univariate analysis on summary data
univariate(FT_sum, CI = 0.90, es_anova = "eta2", digits = 5)
univariate(FT_sum, CI = 0.90, es_anova = "omega2", digits = 5)


# Reproduces Table 2 from Shaw and Mitchell-Olds (1993) using their Table 1.
# See “SMO” dataset for Shaw and Mitchell-Olds (1993) reference
# Note that Table 2 residual df is incorrectly given as 6,
# but is correctly given as 7 in Hector et al. (2010)

# acquiring summary data
univ_SMO <- extract_sum(SMO, test = "uni", run = FALSE)
# univariate analysis on summary data
print(univariate(univ_SMO, type_anova = "I")[[1]])
print(univariate(univ_SMO, type_anova = "II"))
univariate(univ_SMO, type_anova = "III")

}
\references{
Hector, Andy, Stefanie Von Felten, and Bernhard Schmid. "Analysis of variance
  with unbalanced data: an update for ecology & evolution." Journal of animal
  ecology 79.2 (2010): 308-316.
}
