% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuildTC.R
\name{BuildTC}
\alias{BuildTC}
\title{Builds a TideCurve model}
\usage{
BuildTC(
  dataInput = NULL,
  otz = 1,
  astime,
  asdate,
  aedate,
  aetime,
  km = -1,
  mindt = 30,
  keep_data = FALSE
)
}
\arguments{
\item{dataInput}{A data frame with the columns observation_date, observation_time and height. See attached data for correct formats.}

\item{otz}{The time zone of the observations}

\item{astime}{A string indicating the time you want the analysis to start with. Format: "hh:mm:ss"}

\item{asdate}{A string indication the date you want the analysis to start with. Format: "yyyy/mm/dd".}

\item{aedate}{A string indication the date you want the analysis to end with. Format: "yyyy/mm/dd".}

\item{aetime}{A string indicating the time you want the analysis to end with. Format: "hh:mm:ss".}

\item{km}{The number of nodes between two consecutive mean moon transits. Shall be less or equal to: round(1440 [min] / time step [min])
Example: Time step 5 min: Use km = 288 or even smaller. Leave on default (km = -1) and supply mindt, when unsure.}

\item{mindt}{Observation time step in [min]. Default is 30.}

\item{keep_data}{Indicating whether you want to keep the data for computing residuals later. Default is FALSE which keeps the model footprint small.}
}
\value{
A model of class tidecurve, which is a list.
}
\description{
Builds a TideCurve model of class "tidecurve".
}
\examples{

\dontrun{BuildTC(dataInput = tideObservation, asdate = "2015/12/06",
             astime = "00:00:00", aedate = "2015/12/31",
             aetime = "23:30:00")}

}
\references{
\url{https://www.bsh.de/DE/PUBLIKATIONEN/_Anlagen/Downloads/Meer_und_Umwelt/Berichte-des-BSH/Berichte-des-BSH_50_de.pdf?__blob=publicationFile&v=13/}

\doi{https://doi.org/10.5194/os-15-1363-2019}
}
