% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.rank.matrix.R
\name{generate.rank.matrix}
\alias{generate.rank.matrix}
\title{generate.rank.matrix}
\usage{
generate.rank.matrix(p, n, percentageMissing = 0)
}
\arguments{
\item{p}{The number of objects.}

\item{n}{The number of assessors.}

\item{percentageMissing}{The percentage of the missing values. Note, missing data should be resolved by the rank() function before calling estimateTheta().}
}
\value{
A list with simulated data
\itemize{
  \item R.input - The rank matrix 
  \item thea.true - The true underlying signals from the assessments 
  \item sigmas - The standard error of the noise added for each assessor
  \item matrixNoise - The noise added to the true signals in order to get the final rank matrix
}
}
\description{
The generate.rank.matrix() function requires the user to specify the number of objects (items), called p, and the number of assessors, called n. The function simulates full ranked lists (i.e. no missing assignments) without ties.
}
\examples{
p = 8
n = 10
input <- generate.rank.matrix(p, n)
rownames(input$R.input) <- c("a","b","c","d","e","f","g","h")
}
\keyword{generate.rank.matrix}
