% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{date_ts2timeunits}
\alias{date_ts2timeunits}
\title{Conversion d'une date du format date_ts au format TimeUnits}
\usage{
date_ts2timeunits(date_ts, frequency_ts)
}
\arguments{
\item{date_ts}{un vecteur numérique, de préférence \code{integer} au format
\code{AAAA}, \code{c(AAAA, MM)} ou \code{c(AAAA, TT)}}

\item{frequency_ts}{un entier qui vaut \code{4L} (ou \code{4.0}) pour les séries
trimestrielles et \code{12L} (ou \code{12.0}) pour les séries mensuelles.}
}
\value{
En sortie, la fonction retourne la date au format \code{AAAA + TT/4} ou
\code{AAAA + MM/12} (un numeric de longueur 1).
}
\description{
Conversion d'une date du format date_ts au format TimeUnits
}
\details{
\code{AAAA} signifie que l'année est au format numérique avec 4 chiffres
(Exemple : l'année deux mille vingt-deux s'écrit 2022 et non 22)
MM signifie que le mois est au format numérique (Exemple : le mois de mai
s'écrit 5, le moi de décembre s'écrit 12)
TT signifie que le trimestre est au format numérique (Exemple : le troisième
trimestre s'écrit 3)
}
\examples{

# Avril 2020
date_ts2timeunits(date_ts = c(2020L, 4L), frequency_ts = 12L)
# Novembre 2020
date_ts2timeunits(date_ts = c(2022L, 11L), frequency_ts = 12L)

# 4ème trimestre de 2022
date_ts2timeunits(date_ts = c(2022, 4L), frequency_ts = 4L)
# 2ème trimestre de 1995
date_ts2timeunits(date_ts = c(1995L, 2L), frequency_ts = 4L)

}
