% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrendInTrend.R
\name{ttdetect}
\alias{ttdetect}
\title{Finding a detectable odds Ratio with a given power}
\usage{
ttdetect(N, time, G, cstat, alpha_t, beta_0, power, nrep, OR.vec)
}
\arguments{
\item{N}{Sample Size.}

\item{time}{Number of time points.}

\item{G}{Number of CPE strata.}

\item{cstat}{Value of the c-statistic.}

\item{alpha_t}{A scaler that qunatifies the trend in exposure prevalence.}

\item{beta_0}{Intercept of the outcome model.}

\item{power}{A given power.}

\item{nrep}{Number of Monte Carlo replicates.}

\item{OR.vec}{A vector of odds Ratios.}
}
\value{
\item{Power}{A vector of calculated powers for a given OR.vec}
\item{OR.vec}{A vector of odds Ratios}
\item{DetectDifference }{A detectable difference for a given power value}
}
\description{
Monte Carlo power calculation for a trend-in-trend design.
}
\examples{
\donttest{
set.seed(123)
ttdetect(N=10000,time=10,G=10,cstat=0.75,alpha_t= 0.4,beta_0=-4.3,
        power=0.80,nrep=50, OR.vec=c(1.9,2.0,2.1,2.2))
} 
}
\references{
Ertefaie, A., Small, D., Ji, X., Leonard, C., Hennessy, S. (2018). Statistical Power for Trend-in-trend Design. Epidemiology 29(3), e21.
}
