% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_2rm.R
\name{get_cv}
\alias{get_cv}
\alias{cv_2rm}
\alias{static_cv}
\alias{sliding_cv}
\alias{custom_cv}
\title{Coefficient of variation for two-regression models}
\usage{
cv_2rm(
  x,
  window_size = 10,
  approach = c("sliding", "static", "custom"),
  verbose = FALSE,
  ...
)

static_cv(x, window_size)

sliding_cv(x, window_size)

custom_cv(x, window_size, pad_size = window_size - 1, ...)
}
\arguments{
\item{x}{a numeric vector on which to perform the calculation}

\item{window_size}{width of the sliding window, in data points}

\item{approach}{character scalar naming the desired calculation approach to
use. Can be \code{"sliding"} (the default; see Crouter et al., 2010),
\code{"static"} (see Crouter et al., 2006), or \code{"custom"} (see details
below)}

\item{verbose}{logical. Print progress updates?}

\item{...}{arguments passed to functions in the \code{RcppRoll} package}

\item{pad_size}{The number of NA values to append at the start and end of
\code{x} (when \code{approach == "custom"}) before executing the rolling
minimum step.}
}
\value{
a numeric vector of values, giving the desired coefficient of variation
}
\description{
Calculates coefficient of variation using static or sliding methods, with
potential for custom methods as well
}
\details{
For \code{approach == "sliding"}, the value for each epoch
  represents the lowest CV value of all the sliding windows that overlap with
  that epoch. For \code{aproach == "static"}, a truncated vector of CV values
  is given, which reflects CV values from a non-overlapping sliding window.
  For \code{approach == "custom"}, users can pass arguments into
  \code{RcppRoll} functions and create a variation on the sliding approach.
  Behavior of this feature is not well documented and subject to change if
  people start using it and requesting specific behavior.
}
\examples{
data(raw_for_cv)
cv_2rm(raw_for_cv$ENMO)

}
\seealso{
\href{https://pubmed.ncbi.nlm.nih.gov/20400882/}{Crouter et al. (2010, \emph{Med Sci Sports Exerc})}
  \href{https://pubmed.ncbi.nlm.nih.gov/16322367/}{Crouter et al. (2006, \emph{J Appl Physiol})}
}
\keyword{internal}
