% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pearson_correlation_coefficient.R
\name{pearson}
\alias{pearson}
\title{Pearson Correlation Function}
\usage{
pearson(x = NULL, y = NULL, learn = FALSE, interactive = FALSE)
}
\arguments{
\item{x}{Optional first numeric vector (not needed for interactive mode)}

\item{y}{Optional second numeric vector (not needed for interactive mode)}

\item{learn}{Logical, if TRUE shows step-by-step explanation}

\item{interactive}{Logical, if TRUE enables interactive practice mode}
}
\value{
The Pearson correlation coefficient between the two vectors (for non-interactive mode)
}
\description{
This function calculates the Pearson correlation coefficient between two vectors of numbers.
}
\examples{
data <- c(10,4,5,7,3,4,1)
data2 <- c(1,8,3,4,4,5,7)

# Simple calculation
pearson(data, data2)

# Learning mode
pearson(data, data2, learn = TRUE)

# Interactive mode
if(interactive()){
pearson(interactive = TRUE)
}

}
