% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARIMAmodel.R
\name{ARIMAforecast}
\alias{ARIMAforecast}
\title{ARIMAforecast}
\usage{
ARIMAforecast(
  y,
  u = NULL,
  model = NULL,
  cnst = NULL,
  s = frequency(y),
  criterion = "bic",
  h = 2 * s,
  verbose = FALSE,
  lambda = 1,
  maxOrders = c(3, 2, 3, 2, 1, 2),
  bootstrap = FALSE,
  nSimul = 5000,
  fast = FALSE
)
}
\arguments{
\item{y}{a time series to forecast (it may be either a numerical vector or
a time series object). This is the only input required. If a vector, the additional
input \code{s} should be supplied compulsorily (see below).}

\item{u}{a matrix of input time series. If 
the output wanted to be forecast, matrix \code{u} should contain future values for inputs.}

\item{model}{the model to estimate. A vector c(p,d,q,P,D,Q) containing the model orders
of an ARIMA(p,d,q)x(P,D,Q)_s model. A constant may be estimated with the
cnst input.
Use a NULL to automatically identify the ARIMA model.}

\item{cnst}{flag to include a constant in the model (TRUE/FALSE/NULL). Use NULL to estimate}

\item{s}{seasonal period of time series (1 for annual, 4 for quarterly, ...)}

\item{criterion}{information criterion for identification stage ("aic", "bic", "aicc")}

\item{h}{forecast horizon. If the model includes inputs h is not used, the lenght of u is used instead.}

\item{verbose}{intermediate estimation output (TRUE / FALSE)}

\item{lambda}{Box-Cox lambda parameter (NULL: estimate)}

\item{maxOrders}{a vector c(p,d,q,P,D,Q) containing the maximum orders of model orders 
to search for in the automatic identification}

\item{bootstrap}{use bootstrap simulation for predictive distributions}

\item{nSimul}{number of simulation runs for bootstrap simulation of predictive distributions}

\item{fast}{fast identification (avoids post-identification checks)}
}
\value{
An object of class \code{ARIMA}. It is a list with fields including all the inputs and
        the fields listed below as outputs. All the functions in this package fill in
        part of the fields of any \code{ARIMA} object as specified in what follows (function 
        \code{ARIMA} fills in all of them at once):

After running \code{ARIMAforecast} or \code{ARIMA}:
\item{p}{Estimated parameters}
\item{yFor}{Forecasted values of output}
\item{yForV}{Variance of forecasted values of output}
\item{ySimul}{Bootstrap simulations for forecasting distribution evaluation}

After running \code{ARIMAvalidate}:
\item{table}{Estimation and validation table}
}
\description{
Estimates and forecasts ARIMA general univariate models
}
\details{
\code{ARIMAforecast} is a function for modelling and forecasting univariate
time series with Autoregressive Integrated Moving Average (ARIMA) time series models. 
It sets up the model with a number of control variables that
govern the way the rest of functions in the package will work. It also estimates 
the model parameters by Maximum Likelihood and forecasts the data.
}
\examples{
\donttest{
y <- log(AirPassengers)
m1 <- ARIMAforecast(y)
m1 <- ARIMAforecast(y, lambda = NULL)
}
}
\seealso{
\code{\link{ARIMA}}, \code{\link{ARIMAvalidate}},
}
\author{
Diego J. Pedregal
}
