% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UNCOVER.R
\name{predict.UNCOVER}
\alias{predict.UNCOVER}
\title{Prediction method for UNCOVER}
\usage{
\method{predict}{UNCOVER}(object, newX = NULL, type = "prob", ...)
}
\arguments{
\item{object}{Object of class \code{"UNCOVER"}}

\item{newX}{Data frame containing new observations to predict. If not
specified the fitted values will be returned instead.}

\item{type}{Either \code{"prob"} for a probabilistic response prediction or
\code{"response"} for a hard output of the predicted response}

\item{...}{Additional arguments affecting the predictions produced}
}
\value{
Either a data frame of response probabilities with cluster
assignment for each observation or a data frame of predicted responses with
cluster assignment for each observation.
}
\description{
Predicts the response of new observations and their cluster
assignment using an object of class \code{"UNCOVER"}.
}
\details{
Note that this is a Bayesian prediction method and so samples of
the posterior, defined by \code{"UNCOVER"} object provided, will be obtained
through SMC methods for prediction. See \code{\link[=IBIS.logreg]{IBIS.logreg()}} for
more details.
}
\examples{

\donttest{
# First we generate a co-variate matrix and binary response vector
CM <- data.frame(X1 = rnorm(100),X2 = rnorm(100))
rv <- sample(0:1,100,replace=TRUE)

# We can then run UNCOVER with no deforestation criteria
UN.none <- UNCOVER(X = CM,y = rv, deforest_criterion = "None", verbose = FALSE)

# The fitted values of UN.none can then be obtained
predict(UN.none)
predict(UN.none,type = "response")

# We can also predict the response for new data
CM.2 <- data.frame(X1 = rnorm(10),X2 = rnorm(10))
cbind(CM.2,predict(UN.none,newX = CM.2))
}

}
\seealso{
\code{\link[=UNCOVER]{UNCOVER()}}, \code{\link[=IBIS.logreg]{IBIS.logreg()}}
}
\keyword{UNCOVER}
\keyword{predict}
