% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_Treemap.R
\name{Plot.Treemap}
\alias{Plot.Treemap}
\title{Cree un diagrama de árbol (\emph{treemap}) dinámico y flexible con diversos paquetes}
\usage{
Plot.Treemap(
  datos,
  variables,
  atributo,
  textFreq = "N",
  metodo = c("Classic", "Classic2", "Sunburst", "Sunburst2"),
  estadistico = c("Promedio", "Mediana", "Varianza", "SD", "CV", "Min", "Max"),
  colores,
  titulo = "",
  libreria = c("highcharter", "plotly"),
  estilo = NULL,
  estatico = FALSE
)
}
\arguments{
\item{datos}{Un data frame, no un vector numérico.}

\item{variables}{Una lista (\emph{ya sea creada con la sintaxis \code{base} o \code{tidy}})
con las variables categóricas dentro del data frame ingresado en \code{datos} con
las que se desea crear la jerarquía (\emph{recuerde que esta se crea de izquierda
a derecha, es decir la primera hace referencia al grupo, la segunda al subgrupo,
etc.}).}

\item{atributo}{Una variable numérica dentro del data frame ingresado en \code{datos}.
Este es opcional y solo aplica en el caso de un nivel, es decir, cuando se
ingresa únicamente una variable.}

\item{textFreq}{Cadena de caracteres indicando el nombre que se le va a dar al
recuento en cada uno de los grupos. Por defecto se emplea el rótulo "N".}

\item{metodo}{Cadena de caracteres indicando el diseño con el cual se realizará
el gráfico (\emph{en el caso de ingresar dos niveles o más}). Los valores permitidos
son \code{"Classic"} (\emph{valor predeterminado}), \code{"Classic2"}, \code{"Sunburst"} y
\code{"Sunburst2"}, así se usará las funciones d3treeR::d3tree(), d3treeR::d3tree2(),
\link[sunburstR:sunburst]{sunburst()} y \link[sunburstR:sund2b]{sund2b()}
respectivamente.}

\item{estadistico}{Igual uso que en \code{\link[=Plot.Mapa]{Plot.Mapa()}}}

\item{colores}{Igual uso que en \code{\link[=Plot.Series]{Plot.Series()}}, con algunos matices, cuando
usamos \code{Highcharter} y nos encontramos en el caso de un nivel y especificamos
un atributo es recomendable pasarle una escala de colores, pues con esto se
construirá la barra horizontal. En el caso de usar el argumento \code{atributo}
se puede ingresar el nombre de una paleta, por ejemplo "Set1".}

\item{titulo}{Cadena de caracteres indicando el título principal del plot.}

\item{libreria}{Igual uso que en \code{\link[=Plot.Torta]{Plot.Torta()}}, con algunos matices, pues
en el caso de ingresar más de una variable categórica se omitirá dicho
argumento, ya que \code{metodo} tomará su lugar.}

\item{estilo}{Lista compuesta por varios parámetros, los cuales van a ser usados
para graficar el treemap y cuyo objetivo es personalizar pequeños detalles
de éste.
\itemize{
\item \code{hc.Tema} y \code{hc.Credits}: Igual uso que en \code{\link[=Plot.Series]{Plot.Series()}}
\item \code{hc.borderRadius}: Un número entero positivo que indica el radio del borde
de cada elemento. El valor por defecto es 0 (\emph{rectángulos}).
\item \code{ply.Opacidad}: Igual uso que en \code{\link[=Plot.Radar]{Plot.Radar()}}
\item \code{ply.Credits}: Igual uso que en \code{\link[=Plot.Series]{Plot.Series()}}
\item \code{sun.Explanation}: Cadena de caracteres indicando qué es lo que se desea
ver en el centro del sunburst al pasar el mouse por los diferentes anillos
(\emph{niveles de la jerarquía}). Los valores permitidos son "All"
(\emph{valor predeterminado}), "Count" y "Percent". Solo aplica para cuando
\code{metodo = "Sunburst"}.
\item \code{sun.Color}: A diferencia del argumento \code{colores} acá puede pasar una paleta
o vector de colores sin que se recorte (\emph{más no se recicle}) éste a
la longitud de categorías del nodo padre. Su uso reemplaza el funcionamiento
del argumento \code{colores}. Solo aplica para cuando \code{metodo = "Sunburst"}.
\item \code{sun.showLabels}: Si es \code{FALSE} (\emph{valor predeterminado}) no se mostrará
etiquetas en los cortes. Solo aplica para cuando \code{metodo = "Sunburst2"}.
\item \code{sun.colorRoot}: Cadena de caracteres que indica el color del nodo raíz
(\emph{root}). Puede indicar el color con el nombre (\code{"red"}), código
hexadecimal (\code{"#FF0000"}) o RGB (\code{rgb(1, 0, 0)}). El valor por defecto es
"rojo". Solo aplica para cuando \code{metodo = "Sunburst2"}.
\item \code{gg.fontsize.title}: Tamaño de la fuente del título. El valor por defecto
es \code{14}. Para más detalles, consulte la función \link[treemap:treemap]{treemap()}.
\item \code{gg.fontsize.labels}: Tamaño de la fuente de las etiquetas. Si ingresa un
número especificará el tamaño para todos los niveles de agregación, por el
contrario, si ingresa un vector podrá especificar el tamaño para cada nivel.
El valor por defecto es \code{11}. Para más detalles, consulte la función \link[treemap:treemap]{treemap()}.
\item \code{gg.fontcolor.labels}: Especifica los colores de la etiqueta. Ya sea una
cadena de caracteres o un vector (\emph{uno para cada nivel de agregación}).
El valor por defecto es \code{NULL}. Para más detalles, consulte la función \link[treemap:treemap]{treemap()}.
\item \code{gg.border.lwds}: Tamaño de las líneas de borde. Si ingresa un número
especificará el grosor para todos los rectángulos, o un vector para
especificar el grueso para cada nivel de agregación. Para más detalles,
consulte la función \link[treemap:treemap]{treemap()}.
\item \code{gg.border.col}: Color de los bordes dibujados alrededor de cada rectángulo,
ya sea un valor único o un vector. El valor por defecto es \code{'#000000'}.
Para más detalles, consulte la función \link[treemap:treemap]{treemap()}.
\item \code{gg.lowerbound.cex.labels}: Número entre \eqn{[0, 1]}, 0 significa dibujar
todas las etiquetas y 1 significa dibujar sólo las etiquetas si encajan
(\emph{considerando el \code{fontsize.labels}}). El valor por defecto es \code{0.4}.
Para más detalles, consulte la función \link[treemap:treemap]{treemap()}.
\item \code{gg.force.print.labels}: Si es \code{FALSE} (\emph{valor predeterminado}) las
etiquetas de datos no se ven obligadas a imprimirse si no encajan. Para
más detalles consulte la función \link[treemap:treemap]{treemap()}.
\item \code{gg.overlap.labels}: Número entre \eqn{[0, 1]}, que determina la tolerancia
de superposición entre etiquetas. 0 significa que las etiquetas de los
niveles inferiores no se imprimen si las etiquetas de los niveles superiores
se superponen, 1 significa que las etiquetas siempre se imprimen. El valor
por defecto es \code{0.5}. Para más detalles, consulte la función \link[treemap:treemap]{treemap()}.
}}

\item{estatico}{Si es \code{FALSE} (\emph{valor predeterminado}) el gráfico a retornar
será dinámico (\emph{dependiendo de la librería seleccionada}), en caso contrario
se retornará un gráfico estático construido con \code{ggplot2}.}
}
\value{
Retorna el treemap (\emph{objeto widget de HTML}) creado. La clase del objeto
retornado será un "htmlwidget" y dependiendo de la librería usada pertenecerá
adicionalmente a la clase "highchart", "plotly", " d3tree", "d3tree2", "sunburst"
o "sund2b".
}
\description{
Esta función proporciona excelentes herramientas y opciones para la visualización
de datos jerárquicos/estructurados como un conjunto de rectángulos anidados.
Cada grupo está representado por un rectángulo, cuya área (\emph{tamaño}) es
proporcional a su frecuencia absoluta (\emph{recuento}) y el color se usa para
mostrar otra dimensión numérica. Usando la interactividad, es posible representar
varias dimensiones/niveles: grupos, subgrupos, etc. Dicha gráfica se va a
representar usando la librería \code{Highcharter}, \code{Plotly}, \code{d3treeR}, entre otras,
las cuales usan internamente \code{JavaScript}.
}
\details{
Si está trabajando en un \verb{R Markdown} o un aplicativo \code{Shiny} no se puede usar
de forma conjunta el \code{método = Classic} (o \code{Classic2}) y \code{método = Sunburst}
(o \code{Sunburst2}), pues se trata de un problema interno, ya que usan versiones
diferentes de \code{d3}, puede darle seguimiento al problema
\href{https://github.com/timelyportfolio/sunburstR/issues/102}{aquí}. De igual forma,
si utiliza la librería \code{sunburstR} en algunas ocasiones se le verán afectadas
las tablas creadas con \code{DT}.
}
\section{Lista de argumentos de estilo}{


Sabemos que puede ser abrumador el número de argumentos dentro del parámetro
\code{estilo}, pero es necesario si queremos ofrecer al usuario la máxima
personalización dentro de cada función usando cualquier librería. Por tal
razón, a continuación, se detalla el listado completo de argumentos, usados
al especificar la librería y en qué función están presentes
(\emph{marcado con una × si lo posee}).\tabular{clcccccccc}{
   \strong{Librería} \tab \strong{estilo$} \tab \code{\link[=Plot.Series]{Plot.Series()}} \tab \code{\link[=Plot.Barras]{Plot.Barras()}} \tab \code{\link[=Plot.Apiladas]{Plot.Apiladas()}} \tab \code{\link[=Plot.Boxplot]{Plot.Boxplot()}} \tab \code{\link[=Plot.Radar]{Plot.Radar()}} \tab \code{\link[=Plot.Treemap]{Plot.Treemap()}} \tab \code{\link[=Plot.Torta]{Plot.Torta()}} \tab \code{\link[=Plot.Drilldown]{Plot.Drilldown()}} \cr
   — \tab \emph{gg.Tema} \tab × \tab × \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Texto} \tab × \tab × \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Legend} \tab × \tab  \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Linea} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Punto} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Bar} \tab  \tab × \tab × \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.VarWidth} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.OutShape} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.JitWidth} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.JitSize} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Range} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{ggplot2} \tab \emph{gg.plty} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.plwd} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.cglwd} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.cglcol} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.fontsize.title} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.fontsize.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.fontcolor.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.border.lwds} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.border.col} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.lowerbound.cex.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.force.print.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   — \tab \emph{gg.overlap.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   » \tab \emph{hc.Tema} \tab × \tab × \tab × \tab × \tab  \tab × \tab × \tab × \cr
   l \tab \emph{hc.Credits} \tab × \tab × \tab × \tab × \tab  \tab × \tab × \tab × \cr
   \strong{highcharter} \tab \emph{hc.BoxInfo} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{hc.Slider} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   » \tab \emph{hc.borderRadius} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   • \tab \emph{ply.Credits} \tab × \tab × \tab × \tab × \tab × \tab × \tab × \tab  \cr
   ° \tab \emph{ply.Legend} \tab  \tab × \tab  \tab  \tab  \tab  \tab × \tab  \cr
   ° \tab \emph{ply.LegendPosition} \tab × \tab  \tab × \tab × \tab × \tab  \tab  \tab  \cr
   \strong{plotly} \tab \emph{ply.Interaction} \tab × \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   ° \tab \emph{ply.Relleno} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   ° \tab \emph{ply.Opacidad} \tab  \tab  \tab  \tab  \tab × \tab × \tab  \tab  \cr
   • \tab \emph{ply.LegendTitle} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{dygraphs} \tab \emph{dyg.LegendWidth} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   » \tab \emph{dyg.Resaltar} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   — \tab \emph{e.Tema} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{e.Credits} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{echarts4r} \tab \emph{e.Forma} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{e.LegType} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   — \tab \emph{e.LegLoc} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
}
}

\examples{
\dontshow{if (require("viridis")) withAutoprint(\{ # examplesIf}
library(viridis)
Msj <- "Acompa\u00f1ado del Estad\u00edstico seleccionado para la Variable Edad."
Plot.Treemap(
  datos       = ejGraduados,
  variables   = SEDE_NOMBRE_MAT,
  atributo    = EDAD_MOD,
  textFreq    = "Tamaño de la Muestra",
  estadistico = "Max",
  colores     = inferno(10),
  titulo      = "TOTAL DE GRADUADOS POR SEDE DE LA UNIVERSIDAD NACIONAL",
  libreria    = "highcharter",
  estilo      = list(hc.Tema = 7, hc.borderRadius = 20, hc.Credits = Msj)
)
# ---------------------------------------------------------------------------
Plot.Treemap(
  datos       = ejGraduados,
  variables   = FACULTAD,
  atributo    = EDAD_MOD,
  textFreq    = "n",
  estadistico = "CV",
  colores     = turbo(10, direction = -1),
  titulo      = "TOTAL DE GRADUADOS POR FACULTAD EN LA UNAL",
  libreria    = "plotly",
  estilo      = list(ply.Credits = list(x = 0.6, y = 1, text = Msj))
)
\dontshow{\}) # examplesIf}
\dontshow{if (all(FALSE)) withAutoprint(\{ # examplesIf}
# ---------------------------------------------------------------------------
# library(dplyr)
misColores <- c(
  "#29ABE2", # AZUL CLARO  | Amazonia
  "#8CC63F", # VERDE       | Bogota
  "#CC241D", # ROJO        | Caribe
  "#0071BC", # AZUL VIVO   | Manizales
  "#F15A24", # NARANJA     | Medellin
  "#FBB03B", # AMARILLO    | Orinoquia
  "#93278F", # MORADO      | Palmira
  "#8A381A"  # GRIS        | Tumaco
)
Plot.Treemap(
  datos     = ejGraduados,
  variables = vars(SEDE_NOMBRE_MAT, FACULTAD, PROGRAMA),
  metodo    = "Classic",
  colores   = misColores # "Set3"
)
Plot.Treemap(
  datos     = ejGraduados,
  variables = vars(SEDE_NOMBRE_MAT, FACULTAD, PROGRAMA),
  metodo    = "Classic2",
  colores   = "Set2"
)
Plot.Treemap(
  datos     = ejGraduados,
  variables = vars(SEDE_NOMBRE_MAT, FACULTAD, PROGRAMA),
  metodo    = "Sunburst",
  colores   = misColores,
  estilo    = list(sun.Explanation = "All")
)
Plot.Treemap(
  datos     = ejGraduados,
  variables = vars(SEDE_NOMBRE_MAT, FACULTAD, PROGRAMA),
  metodo    = "Sunburst",
  # colores   = misColores,
  estilo    = list(
    sun.Explanation = "All",
    sun.Color = list(range = c("#9E0142", "#D53E4F", "#F46D43", "#FDAE61",
                               "#FEE08B", "#FFFFBF", "#E6F598", "#ABDDA4",
                               "#66C2A5", "#3288BD", "#5E4FA2"
                               )
                     )
  )
)
Plot.Treemap(
  datos     = ejGraduados,
  variables = vars(SEDE_NOMBRE_MAT, FACULTAD, PROGRAMA),
  metodo    = "Sunburst2"
)
Plot.Treemap(
  datos     = ejGraduados,
  variables = vars(SEDE_NOMBRE_MAT, FACULTAD, PROGRAMA),
  metodo    = "Sunburst2",
  colores   = misColores,
  estilo    = list(sun.showLabels = TRUE, sun.colorRoot = "#EF0055")
)
\dontshow{\}) # examplesIf}
\dontshow{if (require("dplyr")) withAutoprint(\{ # examplesIf}
# ---------------------------------------------------------------------------
# Ejemplo usando el caso estático (treemap)
# library(dplyr)
Plot.Treemap(
  datos     = ejGraduados,
  variables = vars(SEDE_NOMBRE_MAT, FACULTAD),
  colores   = c("#FF3232", "#AFFF5E", "#FD6DB3", "#4CCAF2", "#FF9248", "#FBB03B"),
  titulo    = "TOTAL DE GRADUADOS \u00d7 SEDE",
  estatico  = TRUE,
  estilo    = list(
    gg.fontsize.title = 12, gg.fontsize.labels = c(15, 9),
    gg.fontcolor.labels = c("#FFFFFF", "#212020"),
    gg.border.lwds = c(4, 2), gg.border.col = c("#73095D", "#D60D4B"),
    gg.lowerbound.cex.labels = 0.3, gg.overlap.labels = 0.1
  )
)
\dontshow{\}) # examplesIf}
}
