% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printUD.R
\name{printUD}
\alias{printUD}
\alias{print.UD_model}
\alias{print.UD_stage}
\title{Print UD}
\usage{
\method{print}{UD_model}(x, ...)

\method{print}{UD_stage}(x, ...)
}
\arguments{
\item{x}{model wise uncertainty(UD_model class) or stage wise uncertainty(UD_stage class)}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function creates a table summarizing the uncertainty.
}
\examples{
set.seed(0)
stage1 <- LETTERS[1:3]
stage2 <- LETTERS[1:2]
stage3 <- LETTERS[1:4]
y <- rnorm(3*2*4)
data <- expand.grid(stage1=stage1,
                    stage2=stage2,
                    stage3=stage3)
stages <- names(data)
data <- cbind(data, y)

UD_bal_model_range <- UD_bal_model(data, "y", stages, u_range, flist_range)
print(UD_bal_model_range)

UD_bal_stage_range <- UD_model2stage(UD_bal_model_range)
print(UD_bal_stage_range)
}
