% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf.varshrinkest.R
\name{irf.varshrinkest}
\alias{irf.varshrinkest}
\title{Impulse response function}
\usage{
\method{irf}{varshrinkest}(
  x,
  impulse = NULL,
  response = NULL,
  n.ahead = 10,
  ortho = TRUE,
  cumulative = FALSE,
  boot = TRUE,
  ci = 0.95,
  runs = 100,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{Object of class "varshrinkest",
generated by \code{VARshrink()}}

\item{impulse}{A character vector of the impulses,
default is all variables.}

\item{response}{A character vector of the responses,
default is all variables.}

\item{n.ahead}{Integer specifying the steps.}

\item{ortho}{Logical, if TRUE (the default) the
orthogonalised impulse response coefficients are
computed (only for objects of class 'varshrinkest').}

\item{cumulative}{Logical, if TRUE the cumulated impulse
response coefficients are computed. The default value
is false.}

\item{boot}{Logical, if TRUE (the default) bootstrapped
error bands for the imuplse response coefficients are
computed.}

\item{ci}{Numeric, the confidence interval for the
bootstrapped errors bands.}

\item{runs}{An integer, specifying the runs for the
bootstrap.}

\item{seed}{An integer, specifying the seed for the
rng of the bootstrap.}

\item{...}{Currently not used.}
}
\value{
An object of class "varirf", computed by \code{vars::irf()}.
}
\description{
Computes the impulse response coefficients of a VAR(p)
(or transformed VECM to VAR(p)) for n.ahead steps.
}
\details{
This function runs \code{vars::irf()} for an object of class "varshrinkest".
}
\seealso{
\code{\link[vars]{irf}}
}
