% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surGumbelCopula.R
\name{surGumbelCopula}
\alias{surGumbelCopula}
\alias{r90GumbelCopula}
\alias{r270GumbelCopula}
\title{Constructors for survival and rotated Gumbel Copulas}
\usage{
surGumbelCopula(param = 1)

r90GumbelCopula(param = -1)

r270GumbelCopula(param = -1)
}
\arguments{
\item{param}{A single parameter defining the Copula.}
}
\value{
An object of class \linkS4class{surGumbelCopula},
\linkS4class{r90GumbelCopula} or
\linkS4class{r270GumbelCopula} respectively.
}
\description{
These are wrappers to functions from \link[VineCopula:VineCopula-package]{VineCopula::VineCopula-package}
}
\examples{

library(copula)

persp(surGumbelCopula(1.5), dCopula, zlim = c(0, 10))
persp(r90GumbelCopula(-1.5), dCopula, zlim = c(0, 10))
persp(r270GumbelCopula(-1.5), dCopula, zlim = c(0, 10))
}
\keyword{copula}
