% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyl_tree_distance_k.R
\name{phyl_tree_distance_k}
\alias{phyl_tree_distance_k}
\title{Calculate Phylogenetic Tree Distances}
\usage{
phyl_tree_distance_k(input_obj)
}
\arguments{
\item{input_obj}{A `AAStringSet` object containing sequences.}
}
\value{
A numeric vector containing the 5th smallest distances (`Distances_k`) for each leaf in the phylogenetic tree.
}
\description{
This function calculates the pairwise distances between sequences in a phylogenetic tree 
and returns a numeric vector of 5th smallest distances for each leaf in the tree.
}
\details{
The function uses the `ape` package to construct a phylogenetic tree and calculate pairwise distances 
between sequences. The results are returned as a numeric vector.
}
\examples{
# Input file
input_file <- system.file("extdata", "input.fasta", package = "VIProDesign")
seqs <- Biostrings::readAAStringSet(input_file)
distances_k <- phyl_tree_distance_k(seqs)
}
