% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvomega.R
\name{cvomega}
\alias{cvomega}
\title{cvomega}
\usage{
cvomega(sample, omegas, K)
}
\arguments{
\item{sample}{A sample from a \eqn{q}-dimensional random vector \eqn{\mathbf{X}} (\eqn{n \times q} matrix with observations in rows, variables in columns).}

\item{omegas}{A grid of candidate penalty parameters in \eqn{[0,1]}.}

\item{K}{The number of folds to be used.}
}
\value{
The optimal ridge penalty parameter minimizing the cross-validation error.
}
\description{
This functions selects the omega tuning parameter for ridge penalization of the empirical Gaussian copula correlation matrix via cross-validation.
The objective function is the Gaussian log-likelihood, and a grid search is performed using K folds.
}
\details{
The loss function is the Gaussian log-likelihood, i.e., given an estimated (penalized)
Gaussian copula correlation matrix (normal scores rank correlation matrix) \eqn{\widehat{\mathbf{R}}_{n}^{(-j)}} computed on a training set leaving out fold j, and
\eqn{\widehat{\mathbf{R}}_{n}^{(j)}} the empirical (non-penalized)
Gaussian copula correlation matrix computed on test fold j, we search for the tuning parameter that minimizes
\deqn{\sum_{j = 1}^{K} \left [\ln \left ( \left | \widehat{\mathbf{R}}_{n}^{(-j)} \right | \right ) + \text{tr} \left \{\widehat{\mathbf{R}}_{n}^{(j)} \left (\widehat{\mathbf{R}}_{n}^{(-j)} \right )^{-1} \right \} \right ].}
The underlying assumption is that the copula of \eqn{\mathbf{X}} is Gaussian.
}
\examples{
q = 10
n = 50

# AR(1) correlation matrix with correlation 0.5
R = 0.5^(abs(matrix(1:q-1,nrow = q, ncol = q, byrow = TRUE) - (1:q-1)))

# Sample from multivariate normal distribution
sample = mvtnorm::rmvnorm(n,rep(0,q),R,method = "chol")

# 5-fold cross-validation with Gaussian likelihood as loss for selecting omega
omega = cvomega(sample = sample,omegas = seq(0.01,0.999,len = 50),K = 5)

R_est = estR(sample,omega = omega)
}
\references{
De Keyser, S. & Gijbels, I. (2024).
High-dimensional copula-based Wasserstein dependence.
doi: https://doi.org/10.48550/arXiv.2404.07141.

Warton, D.I. (2008).
Penalized normal likelihood and ridge regularization of correlation and covariance matrices.
Journal of the American Statistical Association 103(481):340-349. \cr
doi: https://doi.org/10.1198/016214508000000021.
}
\seealso{
\code{\link{estR}} for computing the (Ridge penalized) empirical Gaussian copula correlation matrix.
}
