% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot.viztest}
\alias{plot.viztest}
\title{Plot Method for viztest Objects}
\usage{
\method{plot}{viztest}(
  x,
  ...,
  add_test_level = TRUE,
  ref_lines = "none",
  viz_diff_thresh = 0.02,
  make_plot = TRUE,
  level = c("ce", "max", "min", "median"),
  trans = I,
  est_point_args = list(color = "black", size = 2),
  opt_ci_args = list(),
  test_ci_args = list(),
  ref_line_args = list(color = "gray75", linetype = 3),
  scale_linewidth_args = list(values = c(3.5, 0.5)),
  scale_color_args = list(values = c("gray75", "black")),
  overall_theme = theme_bw,
  theme_arg = list(legend.position = "top", plot.caption = element_textbox_simple(width =
    unit(1, "npc"), halign = 0, margin = margin(1, 0, 0, 0, "lines"))),
  remove_caption = FALSE
)
}
\arguments{
\item{x}{Object to be plotted, should be of class \code{viztest}}

\item{...}{Other arguments passed down.  Currently not implemented.}

\item{add_test_level}{Add the (1-test level) confidence interval to the plot.  For this to work, you must have specified \code{add_test_level} in the call to \code{viztest()} so that the appropriate confidence intervals can be calculated.}

\item{ref_lines}{Reference lines to be plotted - one of "all", "ambiguous", "none".  This could also be a vector of stimulus names to plot - they should be the same as the names of the estimates in \code{x$est}. See details for explanation.}

\item{viz_diff_thresh}{Threshold for identifying visual difficulty, see details.}

\item{make_plot}{Logical indicating whether the plot should be constructed or the data returned.}

\item{level}{Level at which to plot the estimates.  Accepts both numeric entries or one of "ce", "max", "min", "median" - defaults to "ce", the cognitively easiest level.}

\item{trans}{A function to transform the estimates and their confidence intervals like \code{plogis}.}

\item{est_point_args}{A list of arguments to be passed to \code{geom_point()} that plots the point estimates.}

\item{opt_ci_args}{A list of arguments to be passed to \code{geom_linerange()} to plot the optimal visual testing intervals.}

\item{test_ci_args}{A list of arguments to be passed to \code{geom_linerange()} to plot the (1-test level) confidence intervals.}

\item{ref_line_args}{A list of arguments to be passed to \code{geom_segment()} to plot the reference lines.}

\item{scale_linewidth_args}{A list of arguments to be passed to \code{scale_linewidth_manual()} to change the thickness of the confidence intervals.}

\item{scale_color_args}{A list of arguments to be passed to \code{scale_color_manual()} to change the default color of the different confidence intervals when \code{add_test_level=TRUE}.}

\item{overall_theme}{A theme function that will be passed to the \code{ggplot} call before \code{theme()}. Default is \code{theme_bw}.}

\item{theme_arg}{A list of arguments to be passed to \code{theme()} to modify the theme of the plot.}

\item{remove_caption}{Logical indicating whether caption should be removed.  By default, it is printed to alert the user.}
}
\value{
By default, a ggplot is returned.  If \code{make_plot = FALSE}, the data for the plot are returned, but the plot is not constructed.  If the data are returned, the following variables are in the dataset:
\itemize{
\item \code{vbl} - The name of the parameter.
\item \code{est} - The parameter estimate
\item \code{se} - The standard error of the estimate
\item \code{lwr}, \code{upr} - The inferential confidence bounds being used
\item \code{lwr_add}, \code{upr_add} - The confidence intervals that come from \code{add_level}.
\item \code{label} - Factor giving the parameter names
\item \code{stim_start}, \code{stim_end} - y-axis bounds of the reference line
\item \code{bound_start}, \code{bound_end} - x-axis values for reference lines
\item \code{ambiguous} - Logical vector indicating whether the comparison is considered "ambiguous".
}
}
\description{
Plots the output of viztest objects with optional reference lines
}
\details{
The \code{ref_lines} argument identifies what reference lines will be plotted in the figure.  For any particular stimulus, the reference lines run along the upper bound of the stimulus from the stimulus location to the most distant stimulus with overlapping confidence intervals.
When \code{ref_lines = "all"}, all lines are plotted, though in displays with many stimuli, this can make for a messy graph.  When \code{"ref_lines = ambiguous"} is specified, then only the ones that help discriminate in cases where the result might be visually difficult to discern are plotted.
A comparison is determined to be visually difficult if the upper bound of the stimulus in question is within \code{viz_diff_thresh} times the difference between the smallest lower bound and the largest upper bound.  If \code{ref_lines = "non"}, then none of the reference lines are plotted.
Alternatively, you can specify the names of stimuli whose reference lines will be plotted.  These should be the same as the names in the data.  The \code{viztest()} function returns an object \code{est}, which contains the data that are used as input to this function.  The variable \code{vbl} in
The \code{est} data frame contains the stimulus names.
}
\examples{
data(mtcars)
mod2 <- lm(mpg ~ as.factor(cyl) + vs + am + as.factor(gear), data = mtcars)
v <- viztest(mod2)
plot(v, ref_lines="ambiguous") + ggplot2::theme_classic()

}
