% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_point_density.R
\name{filter_point_density}
\alias{filter_point_density}
\title{Retains one point of the original point cloud within a voxel of given size.}
\usage{
filter_point_density(data, res, message)
}
\arguments{
\item{data}{a data.frame or data.table containing the x, y, z, ... coordinates of a point cloud.}

\item{res}{numeric. The voxel resolution.}

\item{message}{logical. If FALSE, messages are disabled. Default = TRUE.}
}
\value{
a data.frame or data.table with reduced point sensity.
}
\description{
Retains one point of the original point cloud within a voxel of given size.
}
\examples{
#- import tls data
tls=data.table::fread(system.file("extdata", "Tree_t0.asc", package="VoxR"))

#- keep one point in 2cm voxels
filtered=VoxR::filter_point_density(tls,0.02)
rgl::open3d()
rgl::plot3d(filtered,add=TRUE)

#- keep one point in 10cm voxels
filtered=VoxR::filter_point_density(tls,0.1)
rgl::open3d()
rgl::plot3d(filtered,add=TRUE)
}
