% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optparse_helper.R
\name{optparse_list}
\alias{optparse_list}
\title{optparse_list - define a command parameter as a list of objects}
\usage{
optparse_list(
  help = "No documentation yet.",
  short = NULL,
  default = "",
  of = "character",
  sep = ",",
  truevalues = c("TRUE", "true", "1", "t", "T")
)
}
\arguments{
\item{help}{\itemize{
\item The help string to display when --help is triggered
}}

\item{short}{\itemize{
\item The shortcut fir this parameter. For example
for a --output param, we could use
\code{optparse_flag(short = "-o", ...)} to set the "-o" shortcut.
}}

\item{default}{\itemize{
\item The default value this parameter will hold.
}}

\item{of}{\itemize{
\item This type of elements of this list
}}

\item{sep}{\itemize{
\item This character to split on, to get the list
}}

\item{truevalues}{\itemize{
\item A \code{character} vector of different string
values to translate it as \code{TRUE} value.
}}
}
\value{
a list to give to \code{optparse_parameters} to build the
whole command line parsing tool.
}
\description{
To be used with \code{optparse_parameters}. This function tells
the provided parameter is to be parsed as a list of objects.
The \code{of} parameter tells what type are elements of the list.
Each element must be separated by a separator. This separator must
be the value given in the \code{sep} parameter
}
\examples{

str(optparse_parameters(
  a_parameter = optparse_list(of="numeric"),
  b_parameter = optparse_list(of="integer"),
  c_parameter = optparse_list(of="logical"),
  args = list(
    "--a-parameter", "42.7,72.5",
    "--b-parameter", "42.7,72.5",
    "--c-parameter", "TRUE,FALSE,FALSE,TRUE"
  )
))

}
\seealso{
\code{\link[=optparse_parameters]{optparse_parameters()}}
}
\author{
L.Pavot
}
