% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{summary.LRfit}
\alias{summary.LRfit}
\title{Summary of the analysis results}
\usage{
\method{summary}{LRfit}(object, tau = NULL, ref = NULL, joint.test = FALSE, ...)
}
\arguments{
\item{object}{An object returned by \code{\link{LRfit}}.}

\item{tau}{A positive real number for the follow-up time; Default is the maximum
event time in the data.}

\item{ref}{The label of the group to be set as the reference; Default is the
first level by numerical or alphabetical order}

\item{joint.test}{If TRUE, joint analysis with the restricted mean
survival time (RMST) will be performed; Default is FALSE.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
An object of class \code{summary.LRfit} with components

\item{LRtab}{A \eqn{(J\times 4)}-dimensional matrix containing the inference
results for the log-loss rate; Columns include
\code{Estimate}, \code{Std.Err}, \code{Z value}, and \code{Pr(>|z|)}.}

\item{Rtab}{A \eqn{(J\times 4)}-dimensional matrix containing the inference
results for the log-raw cumulative loss if \code{joint.test=TRUE}; Columns include
\code{Estimate}, \code{Std.Err}, \code{Z value}, and \code{Pr(>|z|)}.}

\item{Dtab}{A \eqn{(J\times 4)}-dimensional matrix containing the inference
results for the log-RMST if \code{joint.test=TRUE}; Columns include
\code{Estimate}, \code{Std.Err}, \code{Z value}, and \code{Pr(>|z|)}.}

\item{LRpval}{\eqn{p}-value for the \eqn{(J-1)}-df chi-square test of group difference in the
loss rate.}

\item{LRDpval}{\eqn{p}-value for the \eqn{2(J-1)}-df joint chi-square test of group difference in the
loss rate and RMST.}

\item{...}{}
}
\description{
Summarize the inferential results for group-specific while-alive loss rates
and the loss rate ratios at a user-specified length of follow-up.
}
\examples{
#See examples for LRfit().
}
\seealso{
\code{\link{LRfit}}, \code{\link{plot.LRfit}}.
}
\keyword{LRfit}
