% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Waveletann.R
\name{WaveletFitting}
\alias{WaveletFitting}
\title{Wavelet Transform Using Maximal Overlap Discrete Wavelet Transform (MODWT) Algorithm}
\usage{
WaveletFitting(ts, Wvlevels, Filter = "haar", bndry = "periodic", FFlag = TRUE)
}
\arguments{
\item{ts}{Univariate time series}

\item{Wvlevels}{The level of wavelet decomposition}

\item{Filter}{Wavelet filter}

\item{bndry}{The boundary condition of wavelet decomposition}

\item{FFlag}{The FastFlag condition of wavelet decomposition: True or False}
}
\value{
\itemize{
  \item WaveletSeries - The wavelet transform of the series
}
}
\description{
Wavelet Transform Using Maximal Overlap Discrete Wavelet Transform (MODWT) Algorithm
}
\examples{
data<-rnorm(100,mean=100,sd=50)
WaveletFitting(ts=data,Wvlevels=3,Filter='haar',bndry='periodic',FFlag=TRUE)
}
\references{
\itemize{
\item Aminghafari, M. and Poggi, J.M. 2007. Forecasting time series using wavelets. Internationa Journal of Wavelets, Multiresolution and Inforamtion Processing, 5, 709 to 724
\item Percival D. B. and Walden A. T. 2000. Wavelet Methods for Time-Series Analysis. Cambridge Univ. Press, U.K.
\item Paul R. K., Prajneshu and Ghosh H. 2013. Wavelet Frequency Domain Approach for Modelling and Forecasting of Indian Monsoon Rainfall Time-Series Data. Journal of the Indian society of agricultural statistics, 67, 319 to 327.
}
}
