% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaveletETS.R
\name{WaveletETS}
\alias{WaveletETS}
\title{Wavelet Based Error Trend Seasonality Model}
\usage{
WaveletETS(ts, split_ratio = 0.8, wlevels = 3)
}
\arguments{
\item{ts}{Time Series Data}

\item{split_ratio}{Training and Testing Split}

\item{wlevels}{Number of Wavelet Levels}
}
\value{
\itemize{
  \item Train_actual: Actual train series
  \item Test_actual: Actual test series
  \item Train_fitted: Fitted train series
  \item Test_predicted: Predicted test series
  \item Accuracy: RMSE and MAPE of the model
}
}
\description{
Wavelet Based Error Trend Seasonality Model
}
\examples{
library("WaveletETS")
data<- rnorm(100,100, 10)
WG<-WaveletETS(ts=data)
}
\references{
\itemize{
\item Aminghafari, M. and Poggi, J.M. 2012. Nonstationary time series forecasting using wavelets and kernel smoothing. Communications in Statistics-Theory and Methods, 41(3),485-499.
\item Paul, R.K. A and Anjoy, P. 2018. Modeling fractionally integrated maximum temperature series in India in presence of structural break. Theory and Applied Climatology 134, 241–249.
}
}
