// Generated by rstantools.  Do not edit by hand.

/*
    WhiteLabRt is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    WhiteLabRt is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with WhiteLabRt.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_linelist_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 173> locations_array__ =
  {" (found before start of program)",
  " (in 'linelist', line 71, column 2 to column 18)",
  " (in 'linelist', line 72, column 2 to column 23)",
  " (in 'linelist', line 75, column 2 to column 23)",
  " (in 'linelist', line 77, column 2 to column 25)",
  " (in 'linelist', line 92, column 2 to column 28)",
  " (in 'linelist', line 93, column 2 to column 28)",
  " (in 'linelist', line 103, column 1 to column 33)",
  " (in 'linelist', line 104, column 1 to column 29)",
  " (in 'linelist', line 105, column 1 to column 16)",
  " (in 'linelist', line 106, column 1 to column 16)",
  " (in 'linelist', line 119, column 1 to column 42)",
  " (in 'linelist', line 120, column 1 to column 44)",
  " (in 'linelist', line 133, column 1 to column 26)",
  " (in 'linelist', line 136, column 1 to column 39)",
  " (in 'linelist', line 138, column 1 to column 24)",
  " (in 'linelist', line 151, column 1 to column 24)",
  " (in 'linelist', line 152, column 1 to column 27)",
  " (in 'linelist', line 153, column 1 to column 28)",
  " (in 'linelist', line 173, column 1 to column 29)",
  " (in 'linelist', line 76, column 2 to column 32)",
  " (in 'linelist', line 78, column 2 to column 34)",
  " (in 'linelist', line 97, column 4 to column 56)",
  " (in 'linelist', line 99, column 4 to column 50)",
  " (in 'linelist', line 94, column 21 to line 100, column 3)",
  " (in 'linelist', line 94, column 2 to line 100, column 3)",
  " (in 'linelist', line 113, column 4 to column 37)",
  " (in 'linelist', line 114, column 4 to column 58)",
  " (in 'linelist', line 115, column 4 to column 16)",
  " (in 'linelist', line 112, column 10 to line 116, column 4)",
  " (in 'linelist', line 109, column 5 to column 39)",
  " (in 'linelist', line 110, column 5 to column 33)",
  " (in 'linelist', line 111, column 5 to column 17)",
  " (in 'linelist', line 108, column 26 to line 112, column 4)",
  " (in 'linelist', line 108, column 3 to line 116, column 4)",
  " (in 'linelist', line 107, column 30 to line 117, column 2)",
  " (in 'linelist', line 107, column 1 to line 117, column 2)",
  " (in 'linelist', line 122, column 4 to column 22)",
  " (in 'linelist', line 125, column 8 to column 23)",
  " (in 'linelist', line 124, column 44 to line 126, column 7)",
  " (in 'linelist', line 124, column 6 to line 126, column 7)",
  " (in 'linelist', line 123, column 33 to line 127, column 5)",
  " (in 'linelist', line 123, column 4 to line 127, column 5)",
  " (in 'linelist', line 128, column 4 to column 37)",
  " (in 'linelist', line 129, column 4 to column 44)",
  " (in 'linelist', line 121, column 32 to line 130, column 2)",
  " (in 'linelist', line 121, column 1 to line 130, column 2)",
  " (in 'linelist', line 134, column 1 to column 53)",
  " (in 'linelist', line 137, column 1 to column 72)",
  " (in 'linelist', line 140, column 3 to column 16)",
  " (in 'linelist', line 142, column 6 to column 19)",
  " (in 'linelist', line 143, column 5 to column 33)",
  " (in 'linelist', line 141, column 35 to line 144, column 4)",
  " (in 'linelist', line 141, column 3 to line 144, column 4)",
  " (in 'linelist', line 139, column 22 to line 145, column 2)",
  " (in 'linelist', line 139, column 1 to line 145, column 2)",
  " (in 'linelist', line 155, column 3 to column 73)",
  " (in 'linelist', line 156, column 3 to column 42)",
  " (in 'linelist', line 157, column 3 to column 61)",
  " (in 'linelist', line 158, column 3 to column 64)",
  " (in 'linelist', line 160, column 5 to column 34)",
  " (in 'linelist', line 159, column 21 to line 161, column 4)",
  " (in 'linelist', line 159, column 3 to line 161, column 4)",
  " (in 'linelist', line 163, column 5 to column 33)",
  " (in 'linelist', line 162, column 35 to line 164, column 4)",
  " (in 'linelist', line 162, column 3 to line 164, column 4)",
  " (in 'linelist', line 165, column 3 to column 56)",
  " (in 'linelist', line 154, column 22 to line 166, column 2)",
  " (in 'linelist', line 154, column 1 to line 166, column 2)",
  " (in 'linelist', line 178, column 5 to column 19)",
  " (in 'linelist', line 179, column 5 to column 19)",
  " (in 'linelist', line 184, column 6 to column 33)",
  " (in 'linelist', line 186, column 6 to column 22)",
  " (in 'linelist', line 188, column 9 to column 55)",
  " (in 'linelist', line 187, column 31 to line 189, column 7)",
  " (in 'linelist', line 187, column 6 to line 189, column 7)",
  " (in 'linelist', line 190, column 6 to column 21)",
  " (in 'linelist', line 182, column 40 to line 191, column 6)",
  " (in 'linelist', line 182, column 5 to line 191, column 6)",
  " (in 'linelist', line 193, column 5 to column 37)",
  " (in 'linelist', line 177, column 10 to line 194, column 4)",
  " (in 'linelist', line 176, column 5 to column 15)",
  " (in 'linelist', line 175, column 22 to line 177, column 4)",
  " (in 'linelist', line 175, column 3 to line 194, column 4)",
  " (in 'linelist', line 174, column 32 to line 195, column 2)",
  " (in 'linelist', line 174, column 1 to line 195, column 2)",
  " (in 'linelist', line 82, column 2 to column 23)",
  " (in 'linelist', line 83, column 2 to column 21)",
  " (in 'linelist', line 87, column 2 to column 38)",
  " (in 'linelist', line 52, column 2 to column 21)",
  " (in 'linelist', line 53, column 2 to column 24)",
  " (in 'linelist', line 54, column 9 to column 13)",
  " (in 'linelist', line 54, column 2 to column 23)",
  " (in 'linelist', line 55, column 2 to column 25)",
  " (in 'linelist', line 56, column 2 to column 22)",
  " (in 'linelist', line 57, column 2 to column 27)",
  " (in 'linelist', line 59, column 2 to column 25)",
  " (in 'linelist', line 60, column 9 to column 14)",
  " (in 'linelist', line 60, column 16 to column 17)",
  " (in 'linelist', line 60, column 2 to column 27)",
  " (in 'linelist', line 61, column 25 to column 30)",
  " (in 'linelist', line 61, column 2 to column 32)",
  " (in 'linelist', line 62, column 31 to column 36)",
  " (in 'linelist', line 62, column 2 to column 38)",
  " (in 'linelist', line 64, column 2 to column 27)",
  " (in 'linelist', line 65, column 9 to column 15)",
  " (in 'linelist', line 65, column 17 to column 18)",
  " (in 'linelist', line 65, column 2 to column 29)",
  " (in 'linelist', line 66, column 31 to column 37)",
  " (in 'linelist', line 66, column 2 to column 39)",
  " (in 'linelist', line 68, column 18 to column 32)",
  " (in 'linelist', line 68, column 2 to column 34)",
  " (in 'linelist', line 71, column 9 to column 10)",
  " (in 'linelist', line 75, column 9 to column 14)",
  " (in 'linelist', line 77, column 9 to column 15)",
  " (in 'linelist', line 92, column 9 to column 15)",
  " (in 'linelist', line 93, column 9 to column 15)",
  " (in 'linelist', line 103, column 8 to column 22)",
  " (in 'linelist', line 104, column 8 to column 22)",
  " (in 'linelist', line 119, column 8 to column 24)",
  " (in 'linelist', line 120, column 8 to column 24)",
  " (in 'linelist', line 133, column 8 to column 16)",
  " (in 'linelist', line 136, column 8 to column 16)",
  " (in 'linelist', line 138, column 8 to column 16)",
  " (in 'linelist', line 151, column 8 to column 16)",
  " (in 'linelist', line 152, column 8 to column 16)",
  " (in 'linelist', line 153, column 8 to column 16)",
  " (in 'linelist', line 173, column 8 to column 24)",
  " (in 'linelist', line 3, column 4 to column 28)",
  " (in 'linelist', line 4, column 11 to column 12)",
  " (in 'linelist', line 4, column 4 to column 17)",
  " (in 'linelist', line 5, column 4 to column 12)",
  " (in 'linelist', line 6, column 11 to column 19)",
  " (in 'linelist', line 6, column 4 to column 24)",
  " (in 'linelist', line 7, column 11 to column 19)",
  " (in 'linelist', line 7, column 4 to column 23)",
  " (in 'linelist', line 8, column 11 to column 19)",
  " (in 'linelist', line 8, column 4 to column 24)",
  " (in 'linelist', line 9, column 11 to column 19)",
  " (in 'linelist', line 9, column 4 to column 28)",
  " (in 'linelist', line 10, column 4 to column 18)",
  " (in 'linelist', line 14, column 8 to column 25)",
  " (in 'linelist', line 15, column 8 to column 19)",
  " (in 'linelist', line 13, column 46 to line 16, column 7)",
  " (in 'linelist', line 13, column 6 to line 16, column 7)",
  " (in 'linelist', line 12, column 19 to line 17, column 5)",
  " (in 'linelist', line 12, column 4 to line 17, column 5)",
  " (in 'linelist', line 19, column 11 to column 18)",
  " (in 'linelist', line 19, column 4 to column 33)",
  " (in 'linelist', line 21, column 6 to column 30)",
  " (in 'linelist', line 20, column 27 to line 22, column 5)",
  " (in 'linelist', line 20, column 4 to line 22, column 5)",
  " (in 'linelist', line 23, column 4 to column 20)",
  " (in 'linelist', line 26, column 6 to column 16)",
  " (in 'linelist', line 25, column 26 to line 27, column 5)",
  " (in 'linelist', line 25, column 4 to line 27, column 5)",
  " (in 'linelist', line 32, column 10 to column 21)",
  " (in 'linelist', line 31, column 51 to line 33, column 9)",
  " (in 'linelist', line 31, column 8 to line 33, column 9)",
  " (in 'linelist', line 30, column 23 to line 34, column 7)",
  " (in 'linelist', line 30, column 6 to line 34, column 7)",
  " (in 'linelist', line 29, column 26 to line 35, column 5)",
  " (in 'linelist', line 29, column 4 to line 35, column 5)",
  " (in 'linelist', line 37, column 4 to column 17)",
  " (in 'linelist', line 39, column 4 to column 17)",
  " (in 'linelist', line 41, column 6 to column 29)",
  " (in 'linelist', line 40, column 26 to line 42, column 5)",
  " (in 'linelist', line 40, column 4 to line 42, column 5)",
  " (in 'linelist', line 45, column 6 to column 28)",
  " (in 'linelist', line 44, column 26 to line 46, column 5)",
  " (in 'linelist', line 44, column 4 to line 46, column 5)",
  " (in 'linelist', line 47, column 4 to column 18)",
  " (in 'linelist', line 2, column 60 to line 48, column 3)"};
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T1__>>,-1,1>
prop(const T0__& x_arg__, const T1__& onset_arg__, const int& maxdelay,
     const int& cd, std::ostream* pstream__);
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T1__>>,-1,1>
prop(const T0__& x_arg__, const T1__& onset_arg__, const int& maxdelay,
     const int& cd, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T1__>>;
  int current_statement__ = 0;
  const auto& x = stan::math::to_ref(x_arg__);
  const auto& onset = stan::math::to_ref(onset_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int n = std::numeric_limits<int>::min();
    current_statement__ = 128;
    n = stan::math::num_elements(x);
    current_statement__ = 129;
    stan::math::validate_non_negative_index("x1", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> x1 =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    int dem = std::numeric_limits<int>::min();
    current_statement__ = 132;
    stan::math::validate_non_negative_index("p1", "maxdelay", maxdelay);
    Eigen::Matrix<local_scalar_t__,-1,1> p1 =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(maxdelay, DUMMY_VAR__);
    current_statement__ = 134;
    stan::math::validate_non_negative_index("p", "maxdelay", maxdelay);
    Eigen::Matrix<local_scalar_t__,-1,1> p =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(maxdelay, DUMMY_VAR__);
    current_statement__ = 136;
    stan::math::validate_non_negative_index("p2", "maxdelay", maxdelay);
    Eigen::Matrix<local_scalar_t__,-1,1> p2 =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(maxdelay, DUMMY_VAR__);
    current_statement__ = 138;
    stan::math::validate_non_negative_index("result", "maxdelay", maxdelay);
    Eigen::Matrix<local_scalar_t__,-1,1> result =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(maxdelay, DUMMY_VAR__);
    int count = std::numeric_limits<int>::min();
    current_statement__ = 140;
    count = 1;
    current_statement__ = 146;
    for (int i = 1; i <= n; ++i) {
      current_statement__ = 144;
      if ((stan::math::primitive_value(
             stan::math::logical_lte(
               stan::model::rvalue(x, "x", stan::model::index_uni(i)),
               maxdelay))
          &&
          stan::math::primitive_value(
            stan::math::logical_gte(
              stan::model::rvalue(onset, "onset", stan::model::index_uni(i)),
              cd)))) {
        current_statement__ = 141;
        stan::model::assign(x1,
          stan::model::rvalue(x, "x", stan::model::index_uni(i)),
          "assigning variable x1", stan::model::index_uni(count));
        current_statement__ = 142;
        count = (count + 1);
      }
    }
    current_statement__ = 147;
    stan::math::validate_non_negative_index("x1_truncated", "count - 1",
      (count - 1));
    Eigen::Matrix<local_scalar_t__,-1,1> x1_truncated =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant((count - 1),
        DUMMY_VAR__);
    current_statement__ = 151;
    for (int i = 1; i <= (count - 1); ++i) {
      current_statement__ = 149;
      stan::model::assign(x1_truncated,
        stan::model::rvalue(x1, "x1", stan::model::index_uni(i)),
        "assigning variable x1_truncated", stan::model::index_uni(i));
    }
    current_statement__ = 152;
    dem = (count - 1);
    current_statement__ = 155;
    for (int i = 1; i <= maxdelay; ++i) {
      current_statement__ = 153;
      stan::model::assign(p1, 0, "assigning variable p1",
        stan::model::index_uni(i));
    }
    current_statement__ = 162;
    for (int i = 1; i <= maxdelay; ++i) {
      current_statement__ = 160;
      for (int j = 1; j <= dem; ++j) {
        current_statement__ = 158;
        if (stan::math::logical_eq(
              stan::model::rvalue(x1_truncated, "x1_truncated",
                stan::model::index_uni(j)), ((maxdelay - i) + 1))) {
          current_statement__ = 156;
          stan::model::assign(p1,
            (stan::model::rvalue(p1, "p1", stan::model::index_uni(i)) + 1),
            "assigning variable p1", stan::model::index_uni(i));
        }
      }
    }
    current_statement__ = 163;
    stan::model::assign(p, stan::math::divide(p1, dem),
      "assigning variable p");
    current_statement__ = 164;
    stan::model::assign(p2,
      stan::model::rvalue(p, "p", stan::model::index_uni(1)),
      "assigning variable p2", stan::model::index_uni(1));
    current_statement__ = 167;
    for (int i = 2; i <= maxdelay; ++i) {
      current_statement__ = 165;
      stan::model::assign(p2,
        (stan::model::rvalue(p2, "p2", stan::model::index_uni((i - 1))) +
        stan::model::rvalue(p, "p", stan::model::index_uni(i))),
        "assigning variable p2", stan::model::index_uni(i));
    }
    current_statement__ = 170;
    for (int i = 1; i <= maxdelay; ++i) {
      current_statement__ = 168;
      stan::model::assign(result, (1 -
        stan::model::rvalue(p2, "p2", stan::model::index_uni(i))),
        "assigning variable result", stan::model::index_uni(i));
    }
    current_statement__ = 171;
    return result;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_linelist final : public model_base_crtp<model_linelist> {
private:
  int J;
  int sipN;
  Eigen::Matrix<double,-1,1> sip_data__;
  int maxdelay;
  int ndays;
  int windowsize;
  int N_obs;
  Eigen::Matrix<double,-1,-1> dum_obs_data__;
  std::vector<int> Y_obs;
  std::vector<int> ReportOnset;
  int N_miss;
  Eigen::Matrix<double,-1,-1> dum_miss_data__;
  std::vector<int> ReportDays;
  std::vector<int> missvector;
  int allOnset_1dim__;
  int allY_1dim__;
  int day_onset_tally_1dim__;
  int day_onset_tally_x_1dim__;
  int rt_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> sip{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> dum_obs{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> dum_miss{nullptr, 0, 0};
public:
  ~model_linelist() {}
  model_linelist(stan::io::var_context& context__, unsigned int
                 random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_linelist_namespace::model_linelist";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 89;
      context__.validate_dims("data initialization", "J", "int",
        std::vector<size_t>{});
      J = std::numeric_limits<int>::min();
      current_statement__ = 89;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 89;
      stan::math::check_greater_or_equal(function__, "J", J, 1);
      current_statement__ = 90;
      context__.validate_dims("data initialization", "sipN", "int",
        std::vector<size_t>{});
      sipN = std::numeric_limits<int>::min();
      current_statement__ = 90;
      sipN = context__.vals_i("sipN")[(1 - 1)];
      current_statement__ = 90;
      stan::math::check_greater_or_equal(function__, "sipN", sipN, 1);
      current_statement__ = 91;
      stan::math::validate_non_negative_index("sip", "sipN", sipN);
      current_statement__ = 92;
      context__.validate_dims("data initialization", "sip", "double",
        std::vector<size_t>{static_cast<size_t>(sipN)});
      sip_data__ = Eigen::Matrix<double,-1,1>::Constant(sipN,
                     std::numeric_limits<double>::quiet_NaN());
      new (&sip) Eigen::Map<Eigen::Matrix<double,-1,1>>(sip_data__.data(),
        sipN);
      {
        std::vector<local_scalar_t__> sip_flat__;
        current_statement__ = 92;
        sip_flat__ = context__.vals_r("sip");
        current_statement__ = 92;
        pos__ = 1;
        current_statement__ = 92;
        for (int sym1__ = 1; sym1__ <= sipN; ++sym1__) {
          current_statement__ = 92;
          stan::model::assign(sip, sip_flat__[(pos__ - 1)],
            "assigning variable sip", stan::model::index_uni(sym1__));
          current_statement__ = 92;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 93;
      context__.validate_dims("data initialization", "maxdelay", "int",
        std::vector<size_t>{});
      maxdelay = std::numeric_limits<int>::min();
      current_statement__ = 93;
      maxdelay = context__.vals_i("maxdelay")[(1 - 1)];
      current_statement__ = 93;
      stan::math::check_greater_or_equal(function__, "maxdelay", maxdelay, 1);
      current_statement__ = 94;
      context__.validate_dims("data initialization", "ndays", "int",
        std::vector<size_t>{});
      ndays = std::numeric_limits<int>::min();
      current_statement__ = 94;
      ndays = context__.vals_i("ndays")[(1 - 1)];
      current_statement__ = 94;
      stan::math::check_greater_or_equal(function__, "ndays", ndays, 1);
      current_statement__ = 95;
      context__.validate_dims("data initialization", "windowsize", "int",
        std::vector<size_t>{});
      windowsize = std::numeric_limits<int>::min();
      current_statement__ = 95;
      windowsize = context__.vals_i("windowsize")[(1 - 1)];
      current_statement__ = 95;
      stan::math::check_greater_or_equal(function__, "windowsize",
        windowsize, 1);
      current_statement__ = 96;
      context__.validate_dims("data initialization", "N_obs", "int",
        std::vector<size_t>{});
      N_obs = std::numeric_limits<int>::min();
      current_statement__ = 96;
      N_obs = context__.vals_i("N_obs")[(1 - 1)];
      current_statement__ = 96;
      stan::math::check_greater_or_equal(function__, "N_obs", N_obs, 1);
      current_statement__ = 97;
      stan::math::validate_non_negative_index("dum_obs", "N_obs", N_obs);
      current_statement__ = 98;
      stan::math::validate_non_negative_index("dum_obs", "J", J);
      current_statement__ = 99;
      context__.validate_dims("data initialization", "dum_obs", "double",
        std::vector<size_t>{static_cast<size_t>(N_obs),
          static_cast<size_t>(J)});
      dum_obs_data__ = Eigen::Matrix<double,-1,-1>::Constant(N_obs, J,
                         std::numeric_limits<double>::quiet_NaN());
      new (&dum_obs)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(dum_obs_data__.data(), N_obs,
        J);
      {
        std::vector<local_scalar_t__> dum_obs_flat__;
        current_statement__ = 99;
        dum_obs_flat__ = context__.vals_r("dum_obs");
        current_statement__ = 99;
        pos__ = 1;
        current_statement__ = 99;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 99;
          for (int sym2__ = 1; sym2__ <= N_obs; ++sym2__) {
            current_statement__ = 99;
            stan::model::assign(dum_obs, dum_obs_flat__[(pos__ - 1)],
              "assigning variable dum_obs", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 99;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 100;
      stan::math::validate_non_negative_index("Y_obs", "N_obs", N_obs);
      current_statement__ = 101;
      context__.validate_dims("data initialization", "Y_obs", "int",
        std::vector<size_t>{static_cast<size_t>(N_obs)});
      Y_obs = std::vector<int>(N_obs, std::numeric_limits<int>::min());
      current_statement__ = 101;
      Y_obs = context__.vals_i("Y_obs");
      current_statement__ = 102;
      stan::math::validate_non_negative_index("ReportOnset", "N_obs", N_obs);
      current_statement__ = 103;
      context__.validate_dims("data initialization", "ReportOnset", "int",
        std::vector<size_t>{static_cast<size_t>(N_obs)});
      ReportOnset = std::vector<int>(N_obs, std::numeric_limits<int>::min());
      current_statement__ = 103;
      ReportOnset = context__.vals_i("ReportOnset");
      current_statement__ = 104;
      context__.validate_dims("data initialization", "N_miss", "int",
        std::vector<size_t>{});
      N_miss = std::numeric_limits<int>::min();
      current_statement__ = 104;
      N_miss = context__.vals_i("N_miss")[(1 - 1)];
      current_statement__ = 104;
      stan::math::check_greater_or_equal(function__, "N_miss", N_miss, 1);
      current_statement__ = 105;
      stan::math::validate_non_negative_index("dum_miss", "N_miss", N_miss);
      current_statement__ = 106;
      stan::math::validate_non_negative_index("dum_miss", "J", J);
      current_statement__ = 107;
      context__.validate_dims("data initialization", "dum_miss", "double",
        std::vector<size_t>{static_cast<size_t>(N_miss),
          static_cast<size_t>(J)});
      dum_miss_data__ = Eigen::Matrix<double,-1,-1>::Constant(N_miss, J,
                          std::numeric_limits<double>::quiet_NaN());
      new (&dum_miss)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(dum_miss_data__.data(),
        N_miss, J);
      {
        std::vector<local_scalar_t__> dum_miss_flat__;
        current_statement__ = 107;
        dum_miss_flat__ = context__.vals_r("dum_miss");
        current_statement__ = 107;
        pos__ = 1;
        current_statement__ = 107;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 107;
          for (int sym2__ = 1; sym2__ <= N_miss; ++sym2__) {
            current_statement__ = 107;
            stan::model::assign(dum_miss, dum_miss_flat__[(pos__ - 1)],
              "assigning variable dum_miss", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 107;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 108;
      stan::math::validate_non_negative_index("ReportDays", "N_miss", N_miss);
      current_statement__ = 109;
      context__.validate_dims("data initialization", "ReportDays", "int",
        std::vector<size_t>{static_cast<size_t>(N_miss)});
      ReportDays = std::vector<int>(N_miss, std::numeric_limits<int>::min());
      current_statement__ = 109;
      ReportDays = context__.vals_i("ReportDays");
      current_statement__ = 110;
      stan::math::validate_non_negative_index("missvector", "N_obs + N_miss",
        (N_obs + N_miss));
      current_statement__ = 111;
      context__.validate_dims("data initialization", "missvector", "int",
        std::vector<size_t>{static_cast<size_t>((N_obs + N_miss))});
      missvector = std::vector<int>((N_obs + N_miss),
                     std::numeric_limits<int>::min());
      current_statement__ = 111;
      missvector = context__.vals_i("missvector");
      current_statement__ = 112;
      stan::math::validate_non_negative_index("betas", "J", J);
      current_statement__ = 113;
      stan::math::validate_non_negative_index("mu_obs", "N_obs", N_obs);
      current_statement__ = 114;
      stan::math::validate_non_negative_index("mu_miss", "N_miss", N_miss);
      current_statement__ = 115;
      stan::math::validate_non_negative_index("y_rep_miss", "N_miss", N_miss);
      current_statement__ = 116;
      stan::math::validate_non_negative_index("guessOnset", "N_miss", N_miss);
      current_statement__ = 117;
      allOnset_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 117;
      allOnset_1dim__ = (N_obs + N_miss);
      current_statement__ = 117;
      stan::math::validate_non_negative_index("allOnset", "N_obs + N_miss",
        allOnset_1dim__);
      current_statement__ = 118;
      allY_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 118;
      allY_1dim__ = (N_obs + N_miss);
      current_statement__ = 118;
      stan::math::validate_non_negative_index("allY", "N_obs + N_miss",
        allY_1dim__);
      current_statement__ = 119;
      day_onset_tally_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 119;
      day_onset_tally_1dim__ = (ndays + maxdelay);
      current_statement__ = 119;
      stan::math::validate_non_negative_index("day_onset_tally",
        "ndays + maxdelay", day_onset_tally_1dim__);
      current_statement__ = 120;
      day_onset_tally_x_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 120;
      day_onset_tally_x_1dim__ = (ndays + maxdelay);
      current_statement__ = 120;
      stan::math::validate_non_negative_index("day_onset_tally_x",
        "ndays + maxdelay", day_onset_tally_x_1dim__);
      current_statement__ = 121;
      stan::math::validate_non_negative_index("weights", "maxdelay", maxdelay);
      current_statement__ = 122;
      stan::math::validate_non_negative_index("day_onset_tally_tail",
        "maxdelay", maxdelay);
      current_statement__ = 123;
      stan::math::validate_non_negative_index("check", "maxdelay", maxdelay);
      current_statement__ = 124;
      stan::math::validate_non_negative_index("trunc", "maxdelay", maxdelay);
      current_statement__ = 125;
      stan::math::validate_non_negative_index("mu_local", "maxdelay",
        maxdelay);
      current_statement__ = 126;
      stan::math::validate_non_negative_index("phi_local", "maxdelay",
        maxdelay);
      current_statement__ = 127;
      rt_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 127;
      rt_1dim__ = (ndays + maxdelay);
      current_statement__ = 127;
      stan::math::validate_non_negative_index("rt", "ndays + maxdelay",
        rt_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = J + 1;
  }
  inline std::string model_name() const final {
    return "model_linelist";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_linelist_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> betas =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(J, DUMMY_VAR__);
      current_statement__ = 1;
      betas = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(J);
      local_scalar_t__ phi = DUMMY_VAR__;
      current_statement__ = 2;
      phi = in__.template read_constrain_lb<local_scalar_t__,
              jacobian__>(0.01, lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> mu_obs =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N_obs, DUMMY_VAR__);
      current_statement__ = 20;
      stan::model::assign(mu_obs,
        stan::math::exp(stan::math::multiply(dum_obs, betas)),
        "assigning variable mu_obs");
      Eigen::Matrix<local_scalar_t__,-1,1> mu_miss =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N_miss, DUMMY_VAR__);
      current_statement__ = 21;
      stan::model::assign(mu_miss,
        stan::math::exp(stan::math::multiply(dum_miss, betas)),
        "assigning variable mu_miss");
      {
        current_statement__ = 86;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(betas, 0, 1));
        current_statement__ = 87;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(phi, 0, 1));
        current_statement__ = 88;
        lp_accum__.add(stan::math::neg_binomial_2_lpmf<propto__>(Y_obs,
                         mu_obs, phi));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_linelist_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> betas =
        Eigen::Matrix<double,-1,1>::Constant(J,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      betas = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(J);
      double phi = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      phi = in__.template read_constrain_lb<local_scalar_t__,
              jacobian__>(0.01, lp__);
      Eigen::Matrix<double,-1,1> mu_obs =
        Eigen::Matrix<double,-1,1>::Constant(N_obs,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> mu_miss =
        Eigen::Matrix<double,-1,1>::Constant(N_miss,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(betas);
      out__.write(phi);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 20;
      stan::model::assign(mu_obs,
        stan::math::exp(stan::math::multiply(dum_obs, betas)),
        "assigning variable mu_obs");
      current_statement__ = 21;
      stan::model::assign(mu_miss,
        stan::math::exp(stan::math::multiply(dum_miss, betas)),
        "assigning variable mu_miss");
      if (emit_transformed_parameters__) {
        out__.write(mu_obs);
        out__.write(mu_miss);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> y_rep_miss =
        Eigen::Matrix<double,-1,1>::Constant(N_miss,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> guessOnset =
        Eigen::Matrix<double,-1,1>::Constant(N_miss,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 25;
      for (int n = 1; n <= N_miss; ++n) {
        current_statement__ = 22;
        stan::model::assign(y_rep_miss,
          stan::math::neg_binomial_2_rng(
            stan::model::rvalue(mu_miss, "mu_miss", stan::model::index_uni(n)),
            phi, base_rng__), "assigning variable y_rep_miss",
          stan::model::index_uni(n));
        current_statement__ = 23;
        stan::model::assign(guessOnset,
          (stan::model::rvalue(ReportDays, "ReportDays",
             stan::model::index_uni(n)) -
          stan::model::rvalue(y_rep_miss, "y_rep_miss",
            stan::model::index_uni(n))), "assigning variable guessOnset",
          stan::model::index_uni(n));
      }
      Eigen::Matrix<double,-1,1> allOnset =
        Eigen::Matrix<double,-1,1>::Constant(allOnset_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> allY =
        Eigen::Matrix<double,-1,1>::Constant(allY_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      int i_miss = std::numeric_limits<int>::min();
      current_statement__ = 9;
      i_miss = 1;
      int i_true = std::numeric_limits<int>::min();
      current_statement__ = 10;
      i_true = 1;
      current_statement__ = 36;
      for (int n = 1; n <= (N_obs + N_miss); ++n) {
        current_statement__ = 34;
        if (stan::math::logical_eq(
              stan::model::rvalue(missvector, "missvector",
                stan::model::index_uni(n)), 0)) {
          current_statement__ = 30;
          stan::model::assign(allOnset,
            stan::model::rvalue(ReportOnset, "ReportOnset",
              stan::model::index_uni(i_true)), "assigning variable allOnset",
            stan::model::index_uni(n));
          current_statement__ = 31;
          stan::model::assign(allY,
            stan::model::rvalue(Y_obs, "Y_obs",
              stan::model::index_uni(i_true)), "assigning variable allY",
            stan::model::index_uni(n));
          current_statement__ = 32;
          i_true = (i_true + 1);
        } else {
          current_statement__ = 26;
          stan::model::assign(allOnset,
            stan::model::rvalue(guessOnset, "guessOnset",
              stan::model::index_uni(i_miss)), "assigning variable allOnset",
            stan::model::index_uni(n));
          current_statement__ = 27;
          stan::model::assign(allY,
            (stan::model::rvalue(ReportDays, "ReportDays",
               stan::model::index_uni(i_miss)) -
            stan::model::rvalue(guessOnset, "guessOnset",
              stan::model::index_uni(i_miss))), "assigning variable allY",
            stan::model::index_uni(n));
          current_statement__ = 28;
          i_miss = (i_miss + 1);
        }
      }
      Eigen::Matrix<double,-1,1> day_onset_tally =
        Eigen::Matrix<double,-1,1>::Constant(day_onset_tally_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> day_onset_tally_x =
        Eigen::Matrix<double,-1,1>::Constant(day_onset_tally_x_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 46;
      for (int j = 1; j <= (ndays + maxdelay); ++j) {
        int local_sum = std::numeric_limits<int>::min();
        current_statement__ = 37;
        local_sum = 0;
        current_statement__ = 42;
        for (int n = 1; n <= (N_obs + N_miss); ++n) {
          current_statement__ = 40;
          if (stan::math::logical_eq(
                stan::model::rvalue(allOnset, "allOnset",
                  stan::model::index_uni(n)), ((j - maxdelay) + 1))) {
            current_statement__ = 38;
            local_sum = (local_sum + 1);
          }
        }
        current_statement__ = 43;
        stan::model::assign(day_onset_tally, local_sum,
          "assigning variable day_onset_tally", stan::model::index_uni(j));
        current_statement__ = 44;
        stan::model::assign(day_onset_tally_x, ((j - maxdelay) + 1),
          "assigning variable day_onset_tally_x", stan::model::index_uni(j));
      }
      Eigen::Matrix<double,-1,1> weights =
        Eigen::Matrix<double,-1,1>::Constant(maxdelay,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 47;
      stan::model::assign(weights,
        prop(allY, allOnset, maxdelay, -maxdelay, pstream__),
        "assigning variable weights");
      Eigen::Matrix<double,-1,1> day_onset_tally_tail =
        Eigen::Matrix<double,-1,1>::Constant(maxdelay,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 48;
      stan::model::assign(day_onset_tally_tail,
        stan::model::rvalue(day_onset_tally, "day_onset_tally",
          stan::model::index_min_max((ndays + 1), (ndays + maxdelay))),
        "assigning variable day_onset_tally_tail");
      Eigen::Matrix<double,-1,1> check =
        Eigen::Matrix<double,-1,1>::Constant(maxdelay,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 55;
      for (int i = 1; i <= maxdelay; ++i) {
        current_statement__ = 49;
        stan::model::assign(check, 0, "assigning variable check",
          stan::model::index_uni(i));
        current_statement__ = 53;
        if (stan::math::logical_lt(
              stan::model::rvalue(day_onset_tally_tail,
                "day_onset_tally_tail", stan::model::index_uni(i)), 1)) {
          current_statement__ = 50;
          stan::model::assign(check, 1, "assigning variable check",
            stan::model::index_uni(i));
          current_statement__ = 51;
          stan::model::assign(day_onset_tally_tail, 1,
            "assigning variable day_onset_tally_tail",
            stan::model::index_uni(i));
        }
      }
      Eigen::Matrix<double,-1,1> trunc =
        Eigen::Matrix<double,-1,1>::Constant(maxdelay,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> mu_local =
        Eigen::Matrix<double,-1,1>::Constant(maxdelay,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> phi_local =
        Eigen::Matrix<double,-1,1>::Constant(maxdelay,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 68;
      for (int i = 1; i <= maxdelay; ++i) {
        current_statement__ = 56;
        stan::model::assign(mu_local,
          ((stan::model::rvalue(day_onset_tally_tail, "day_onset_tally_tail",
              stan::model::index_uni(i)) * (1 -
          stan::model::rvalue(weights, "weights", stan::model::index_uni(i))))
          /
          stan::model::rvalue(weights, "weights", stan::model::index_uni(i))),
          "assigning variable mu_local", stan::model::index_uni(i));
        current_statement__ = 57;
        stan::model::assign(phi_local,
          stan::model::rvalue(day_onset_tally_tail, "day_onset_tally_tail",
            stan::model::index_uni(i)), "assigning variable phi_local",
          stan::model::index_uni(i));
        current_statement__ = 58;
        stan::model::assign(trunc,
          stan::math::neg_binomial_2_rng(
            stan::model::rvalue(mu_local, "mu_local",
              stan::model::index_uni(i)),
            stan::model::rvalue(phi_local, "phi_local",
              stan::model::index_uni(i)), base_rng__),
          "assigning variable trunc", stan::model::index_uni(i));
        current_statement__ = 59;
        stan::model::assign(day_onset_tally_tail,
          (stan::model::rvalue(day_onset_tally_tail, "day_onset_tally_tail",
             stan::model::index_uni(i)) +
          stan::model::rvalue(trunc, "trunc", stan::model::index_uni(i))),
          "assigning variable day_onset_tally_tail",
          stan::model::index_uni(i));
        current_statement__ = 62;
        if (stan::math::logical_eq(
              stan::model::rvalue(check, "check", stan::model::index_uni(i)),
              1)) {
          current_statement__ = 60;
          stan::model::assign(day_onset_tally_tail,
            (stan::model::rvalue(day_onset_tally_tail,
               "day_onset_tally_tail", stan::model::index_uni(i)) - 1),
            "assigning variable day_onset_tally_tail",
            stan::model::index_uni(i));
        }
        current_statement__ = 65;
        if (stan::math::logical_lt(
              stan::model::rvalue(day_onset_tally_tail,
                "day_onset_tally_tail", stan::model::index_uni(i)), 0)) {
          current_statement__ = 63;
          stan::model::assign(day_onset_tally_tail, 0,
            "assigning variable day_onset_tally_tail",
            stan::model::index_uni(i));
        }
        current_statement__ = 66;
        stan::model::assign(day_onset_tally,
          stan::model::rvalue(day_onset_tally_tail, "day_onset_tally_tail",
            stan::model::index_uni(i)), "assigning variable day_onset_tally",
          stan::model::index_uni((ndays + i)));
      }
      Eigen::Matrix<double,-1,1> rt =
        Eigen::Matrix<double,-1,1>::Constant(rt_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 85;
      for (int t = 1; t <= (ndays + maxdelay); ++t) {
        current_statement__ = 83;
        if (stan::math::logical_lt(t, windowsize)) {
          current_statement__ = 81;
          stan::model::assign(rt, 0, "assigning variable rt",
            stan::model::index_uni(t));
        } else {
          double num1 = std::numeric_limits<double>::quiet_NaN();
          current_statement__ = 69;
          num1 = 0;
          double den1 = std::numeric_limits<double>::quiet_NaN();
          current_statement__ = 70;
          den1 = 0;
          current_statement__ = 78;
          for (int k = ((t - windowsize) + 1); k <= t; ++k) {
            current_statement__ = 71;
            num1 = (num1 +
              stan::model::rvalue(day_onset_tally, "day_onset_tally",
                stan::model::index_uni(k)));
            double lambda = std::numeric_limits<double>::quiet_NaN();
            current_statement__ = 72;
            lambda = 0;
            current_statement__ = 75;
            for (int j = 1; j <= stan::math::min(k, sipN); ++j) {
              current_statement__ = 73;
              lambda = (lambda +
                (stan::model::rvalue(day_onset_tally, "day_onset_tally",
                   stan::model::index_uni(((k - j) + 1)))
                *
                stan::model::rvalue(sip, "sip", stan::model::index_uni(j))));
            }
            current_statement__ = 76;
            den1 = (den1 + lambda);
          }
          current_statement__ = 79;
          stan::model::assign(rt, ((num1 + 1) / (den1 + 0.2)),
            "assigning variable rt", stan::model::index_uni(t));
        }
      }
      out__.write(y_rep_miss);
      out__.write(guessOnset);
      out__.write(allOnset);
      out__.write(allY);
      out__.write(i_miss);
      out__.write(i_true);
      out__.write(day_onset_tally);
      out__.write(day_onset_tally_x);
      out__.write(weights);
      out__.write(day_onset_tally_tail);
      out__.write(check);
      out__.write(trunc);
      out__.write(mu_local);
      out__.write(phi_local);
      out__.write(rt);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> betas =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(J, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(betas,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(J),
        "assigning variable betas");
      out__.write(betas);
      local_scalar_t__ phi = DUMMY_VAR__;
      current_statement__ = 2;
      phi = in__.read<local_scalar_t__>();
      out__.write_free_lb(0.01, phi);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "betas", "double",
        std::vector<size_t>{static_cast<size_t>(J)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "phi", "double",
        std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> betas =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(J, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> betas_flat__;
        current_statement__ = 1;
        betas_flat__ = context__.vals_r("betas");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(betas, betas_flat__[(pos__ - 1)],
            "assigning variable betas", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(betas);
      local_scalar_t__ phi = DUMMY_VAR__;
      current_statement__ = 2;
      phi = context__.vals_r("phi")[(1 - 1)];
      out__.write_free_lb(0.01, phi);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"betas", "phi"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"mu_obs", "mu_miss"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string>
        temp{"y_rep_miss", "guessOnset", "allOnset", "allY", "i_miss",
             "i_true", "day_onset_tally", "day_onset_tally_x", "weights",
             "day_onset_tally_tail", "check", "trunc", "mu_local",
             "phi_local", "rt"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(J)},
                std::vector<size_t>{}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N_obs)},
             std::vector<size_t>{static_cast<size_t>(N_miss)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N_miss)},
             std::vector<size_t>{static_cast<size_t>(N_miss)},
             std::vector<size_t>{static_cast<size_t>(allOnset_1dim__)},
             std::vector<size_t>{static_cast<size_t>(allY_1dim__)},
             std::vector<size_t>{}, std::vector<size_t>{},
             std::vector<size_t>{static_cast<size_t>(day_onset_tally_1dim__)},
             std::vector<size_t>{static_cast<size_t>(day_onset_tally_x_1dim__)},
             std::vector<size_t>{static_cast<size_t>(maxdelay)},
             std::vector<size_t>{static_cast<size_t>(maxdelay)},
             std::vector<size_t>{static_cast<size_t>(maxdelay)},
             std::vector<size_t>{static_cast<size_t>(maxdelay)},
             std::vector<size_t>{static_cast<size_t>(maxdelay)},
             std::vector<size_t>{static_cast<size_t>(maxdelay)},
             std::vector<size_t>{static_cast<size_t>(rt_1dim__)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      param_names__.emplace_back(std::string() + "betas" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "phi");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu_obs" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_miss; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu_miss" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N_miss; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_rep_miss" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_miss; ++sym1__) {
        param_names__.emplace_back(std::string() + "guessOnset" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= allOnset_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "allOnset" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= allY_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "allY" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "i_miss");
      param_names__.emplace_back(std::string() + "i_true");
      for (int sym1__ = 1; sym1__ <= day_onset_tally_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "day_onset_tally" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= day_onset_tally_x_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "day_onset_tally_x" + '.'
          + std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= maxdelay; ++sym1__) {
        param_names__.emplace_back(std::string() + "weights" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= maxdelay; ++sym1__) {
        param_names__.emplace_back(std::string() + "day_onset_tally_tail" +
          '.' + std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= maxdelay; ++sym1__) {
        param_names__.emplace_back(std::string() + "check" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= maxdelay; ++sym1__) {
        param_names__.emplace_back(std::string() + "trunc" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= maxdelay; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu_local" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= maxdelay; ++sym1__) {
        param_names__.emplace_back(std::string() + "phi_local" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= rt_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "rt" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      param_names__.emplace_back(std::string() + "betas" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "phi");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu_obs" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_miss; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu_miss" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N_miss; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_rep_miss" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_miss; ++sym1__) {
        param_names__.emplace_back(std::string() + "guessOnset" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= allOnset_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "allOnset" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= allY_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "allY" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "i_miss");
      param_names__.emplace_back(std::string() + "i_true");
      for (int sym1__ = 1; sym1__ <= day_onset_tally_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "day_onset_tally" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= day_onset_tally_x_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "day_onset_tally_x" + '.'
          + std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= maxdelay; ++sym1__) {
        param_names__.emplace_back(std::string() + "weights" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= maxdelay; ++sym1__) {
        param_names__.emplace_back(std::string() + "day_onset_tally_tail" +
          '.' + std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= maxdelay; ++sym1__) {
        param_names__.emplace_back(std::string() + "check" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= maxdelay; ++sym1__) {
        param_names__.emplace_back(std::string() + "trunc" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= maxdelay; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu_local" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= maxdelay; ++sym1__) {
        param_names__.emplace_back(std::string() + "phi_local" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= rt_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "rt" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"betas\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(J) + "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu_obs\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_obs) + "},\"block\":\"transformed_parameters\"},{\"name\":\"mu_miss\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_miss) + "},\"block\":\"transformed_parameters\"},{\"name\":\"y_rep_miss\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_miss) + "},\"block\":\"generated_quantities\"},{\"name\":\"guessOnset\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_miss) + "},\"block\":\"generated_quantities\"},{\"name\":\"allOnset\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(allOnset_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"allY\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(allY_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"i_miss\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"i_true\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"day_onset_tally\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(day_onset_tally_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"day_onset_tally_x\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(day_onset_tally_x_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"weights\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(maxdelay) + "},\"block\":\"generated_quantities\"},{\"name\":\"day_onset_tally_tail\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(maxdelay) + "},\"block\":\"generated_quantities\"},{\"name\":\"check\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(maxdelay) + "},\"block\":\"generated_quantities\"},{\"name\":\"trunc\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(maxdelay) + "},\"block\":\"generated_quantities\"},{\"name\":\"mu_local\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(maxdelay) + "},\"block\":\"generated_quantities\"},{\"name\":\"phi_local\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(maxdelay) + "},\"block\":\"generated_quantities\"},{\"name\":\"rt\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(rt_1dim__) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"betas\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(J) + "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu_obs\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_obs) + "},\"block\":\"transformed_parameters\"},{\"name\":\"mu_miss\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_miss) + "},\"block\":\"transformed_parameters\"},{\"name\":\"y_rep_miss\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_miss) + "},\"block\":\"generated_quantities\"},{\"name\":\"guessOnset\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_miss) + "},\"block\":\"generated_quantities\"},{\"name\":\"allOnset\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(allOnset_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"allY\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(allY_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"i_miss\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"i_true\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"day_onset_tally\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(day_onset_tally_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"day_onset_tally_x\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(day_onset_tally_x_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"weights\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(maxdelay) + "},\"block\":\"generated_quantities\"},{\"name\":\"day_onset_tally_tail\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(maxdelay) + "},\"block\":\"generated_quantities\"},{\"name\":\"check\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(maxdelay) + "},\"block\":\"generated_quantities\"},{\"name\":\"trunc\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(maxdelay) + "},\"block\":\"generated_quantities\"},{\"name\":\"mu_local\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(maxdelay) + "},\"block\":\"generated_quantities\"},{\"name\":\"phi_local\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(maxdelay) + "},\"block\":\"generated_quantities\"},{\"name\":\"rt\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(rt_1dim__) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (J + 1);
    const size_t num_transformed = emit_transformed_parameters * ((N_obs +
      N_miss));
    const size_t num_gen_quantities = emit_generated_quantities *
      (((((((((((((((N_miss + N_miss) + allOnset_1dim__) + allY_1dim__) + 1)
      + 1) + day_onset_tally_1dim__) + day_onset_tally_x_1dim__) + maxdelay)
      + maxdelay) + maxdelay) + maxdelay) + maxdelay) + maxdelay) +
      rt_1dim__));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (J + 1);
    const size_t num_transformed = emit_transformed_parameters * ((N_obs +
      N_miss));
    const size_t num_gen_quantities = emit_generated_quantities *
      (((((((((((((((N_miss + N_miss) + allOnset_1dim__) + allY_1dim__) + 1)
      + 1) + day_onset_tally_1dim__) + day_onset_tally_x_1dim__) + maxdelay)
      + maxdelay) + maxdelay) + maxdelay) + maxdelay) + maxdelay) +
      rt_1dim__));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_linelist_namespace::model_linelist;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_linelist_namespace::profiles__;
}
#endif
#endif
