% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t1.voi.R
\docType{data}
\name{t1.voi.hist}
\alias{t1.voi.hist}
\title{Histogram of VOI of T1 template image}
\format{
A volume of interest histogram from a T1 image for smoothing
}
\usage{
t1.voi.hist
}
\description{
Histogram of VOI of T1 template image
}
\examples{
\donttest{
lib.loc = tempdir()
if (download_img_data(lib.loc = lib.loc)){
  t1 = oro.nifti::readNIfTI(system.file("T1Strip.nii.gz", package="WhiteStripe",
                             lib.loc = lib.loc))
  t1.voi = make_img_voi(t1)
  any(is.na(t1.voi))
  # FALSE
  t1.voi.hist = hist(t1.voi,
                     breaks=2000,
                     plot=FALSE)
}
} 
}
\keyword{datasets}
