% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WPL1.R
\name{WPL1}
\alias{WPL1}
\title{p-Wasserstein Linear Projections With an \eqn{L_1} Penalty}
\usage{
WPL1(
  X,
  Y = NULL,
  theta = NULL,
  power = 2,
  penalty = c("lasso", "ols", "mcp", "elastic.net", "selection.lasso", "scad", "mcp.net",
    "scad.net", "grp.lasso", "grp.lasso.net", "grp.mcp", "grp.scad", "grp.mcp.net",
    "grp.scad.net", "sparse.grp.lasso"),
  model.size = NULL,
  lambda = numeric(0),
  nlambda = 100L,
  lambda.min.ratio = 1e-04,
  gamma = 1,
  alpha = 1,
  maxit = 500L,
  tol = 1e-07,
  ...
)
}
\arguments{
\item{X}{matrix of covariates}

\item{Y}{matrix of predictions}

\item{theta}{optional parameter matrix for selection methods.}

\item{power}{power of the Wasserstein distance}

\item{penalty}{Form of penalty. One of "lasso", "ols", "mcp", "elastic.net","selection.lasso", "scad", "mcp.net", "scad.net", "grp.lasso", "grp.lasso.net", "grp.mcp","grp.scad", "grp.mcp.net", "grp.scad.net", "sparse.grp.lasso"}

\item{model.size}{How many coefficients should final model have}

\item{lambda}{penalty parameter}

\item{nlambda}{number of lambdas to explore}

\item{lambda.min.ratio}{minimum ratio of max to min lambda}

\item{gamma}{Tuning parameter for SCAD and MCP methods}

\item{maxit}{maximum iterations for optimization}

\item{tol}{tolerance for convergence}

\item{...}{arguments passed to other methods such as Wasserstein distance}
}
\value{
object of class \code{WpProj}
}
\description{
p-Wasserstein Linear Projections With an \eqn{L_1} Penalty
}
\seealso{
\code{\link[=W1L1]{W1L1()}}, \code{\link[=W2L1]{W2L1()}}, \link{WInfL1}
}
\keyword{internal}
