% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqr.R
\name{ZIP}
\alias{ZIP}
\alias{dzip}
\alias{pzip}
\alias{qzip}
\alias{rzip}
\title{The Zero-Inflated Poisson Distribution}
\usage{
dzip(x, lambda, omega, log = FALSE)
pzip(q, lambda, omega, lower.tail = TRUE, log.p = FALSE)
qzip(p, lambda, omega, lower.tail = TRUE, log.p = FALSE)
rzip(n, lambda, omega)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{p}{vector of probabilities.}

\item{n}{number of random values to return.}

\item{lambda}{vector of (non-negative) means.}

\item{omega}{zero-inflation parameter.}

\item{log, log.p}{logical; if TRUE, probabilities \code{p} are given as \code{log(p)}.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \code{P[X <= x]}, otherwise, \code{P[X > x]}.}
}
\value{
\code{dzip} gives the density, \code{pzip} gives the distribution function,
\code{qzip} gives the quantile function, and \code{rzip} generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation for the 
zero-inflated Poisson (ZIP) distribution with parameters \code{lambda} and \code{omega}.
}
\examples{
dzip(x = 0:10, lambda = 1, omega = 0.5)
pzip(q = c(1, 5, 9), lambda = 1, omega = 0.5)
qzip(p = c(0.25, 0.50, 0.75), lambda = 1, omega = 0.5)
set.seed(123)
rzip(n = 100, lambda = 1, omega = 0.5)
}
\seealso{
\code{\link{dzinb}}, \code{\link{pzinb}}, \code{\link{qzinb}}, and \code{\link{rzinb}}
for the zero-inflated negative binomial (ZINB) distribution.
}
\keyword{distribution}
