% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aIc.R
\name{aIc.coherent}
\alias{aIc.coherent}
\title{Calculate the subcompositional coherence of samples in
a dataset for a given correction.}
\usage{
aIc.coherent(
  data,
  norm.method = "prop",
  zero.remove = 0.95,
  zero.method = "prior",
  log = FALSE,
  group = NULL,
  cor.test = "spearman"
)
}
\arguments{
\item{data}{can be any dataframe or matrix with samples by column}

\item{norm.method}{can be prop, clr, RLE, TMM, TMMwsp, lvha, iqlr}

\item{zero.remove}{is a value. Filter data to remove features that are 0 
across at least that proportion of samples: default 0.95}

\item{zero.method}{can be any of NULL, prior, GBM or CZM. NULL will not 
impute or change 0 values, GBM and CZM are from the 
zCompositions R package, and prior will simply add 0.5 to all counts.}

\item{log}{is a logical. log transform the prop, RLE or TMM outputs, default=FALSE}

\item{group}{is a vector containing group information. Required for clr, RLE,}

\item{cor.test}{is either the pearson or spearman method (default)}
}
\value{
Returns a list with the correlation in \code{cor}, a yes/no binary 
decision in \code{is.coherent},  the x and y values for a scatterplot
of the correlations in the full and subcompositions, and the plot and axis
labels in \code{main} \code{xlab} and \code{ylab}.
}
\description{
`aIc.coherent` compares the correlation coefficients
of features in common of the full dataset and a subset of the dataset.
This is expected to be false for all compositional datasets and transforms.
}
\examples{
data(selex)
group = c(rep('N', 7), rep('S', 7))
x <- aIc.coherent(selex, group=group, norm.method='clr', zero.method='prior')
plot(x$plot[,1], x$plot[,2], main=x$main, ylab=x$ylab, xlab=x$xlab)

}
\author{
Greg Gloor
}
