% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{binomial_deviance}
\alias{binomial_deviance}
\alias{cy_dissimilarity}
\title{Binomial deviance and CY index of dissimilarity}
\usage{
binomial_deviance(x, y)

cy_dissimilarity(x, y, base = 10, min_value = 0.1)
}
\arguments{
\item{x, y}{Numeric vectors}

\item{base}{Base of the logarithm}

\item{min_value}{Replacement for zero or near-zero values. Values less than
\code{min_value} are replaced with \code{min_value}.}
}
\value{
The Binomial deviance or CY index of dissimilarity. The CY index is
  undefined if all elements of \code{x} and \code{y} are zero, in which case
  we return \code{NaN}.
}
\description{
The binomial deviance dissimilarity and the CY (or Cao) index of
dissimilarity were created to compare species counts at sites with moderate
to large differences.
}
\details{
Both of these measures were designed to be used with whole-numbered counts,
and may not make sense for comparing normalized vectors or vectors of
species proportions.

For two vectors \code{x} and \code{y}, the binomial deviance dissimilarity
is
\deqn{
  d(x,y) = \sum_i{
    \frac{1}{n_i}
    \left (
      x_i \log{\frac{x_i}{n_i}} +
      y_i \log{\frac{y_i}{n_i}} -
      (x_i + y_i) log{2}
    \right )
  },
}
where \eqn{n_i = x_i + y_i}. This value is the weighted average of the
deviance for each species, under a binomial model where the expected counts
are \eqn{n_i / 2} at each site. It was proposed by Anderson and Millar in
2004. Relation to other definitions:
\itemize{
  \item Equivalent to vegdist() with method = "binomial".
}

The CY index was proposed by Cao, Williams, and Bark in 1997. For two
vectors \code{x} and \code{y}, the CY index is
\deqn{
  d(x,y) = \frac{1}{N} \sum_i
  \left (
    \frac{
      (x_i + y_i) \log_{10} ( \frac{x_i + y_i}{2} ) -
      x_i \log_{10}(y_i) - y_i \log_{10}(x_i)
    }{
      x_i + y_i
    }
  \right ),
}
where \eqn{N} is the total number of species in vectors \eqn{x} and \eqn{y}.
Double zeros are not considered in the measure.

When either \eqn{x_i} or \eqn{y_i} are zero, they need to be replaced by
another value in the CY index to avoid infinities. Cao suggested replacing
zero values with \eqn{0.1}, which is one log lower than the minimum value
for whole-numbered counts. Here, we use a \code{min_value} argument to allow
the user set a lower limit on the values. For vectors of species counts,
this function follows the formulation of Cao by default.

Relation of the CY index to other definitions:
\itemize{
  \item Equivalent to the \code{vegdist()} function with
    \code{method = "cao"}, if \code{base = exp(1)}.
}
}
\references{
Anderson MJ, Millar RB. Spatial variation and effects of habitat on
temperate reef fish assemblages in northeastern New Zealand. Journal of
Experimental Marine Biology and Ecology 2004;305:191–221.

Cao Y, Williams WP, Bark AW. Similarity measure bias in river benthic
Aufwuchs community analysis. Water Environment Research 1997;69(1):95-106.
}
