% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unifrac.R
\name{faith_pd}
\alias{faith_pd}
\title{Faith's phylogenetic diversity}
\usage{
faith_pd(x, tree, x_labels = NULL)
}
\arguments{
\item{x}{A numeric vector of species counts or proportions, or a logical
vector of species presence/absence.}

\item{tree}{A phylogenetic tree object..}

\item{x_labels}{A character vector of species labels for \code{x}.}
}
\value{
Faith's phylogenetic diversity, \eqn{PD \geq 0}.
}
\description{
Faith's phylogenetic diversity gives the total branch length on a
phylogenetic tree that is spanned by a community.  The abundance of each
species in the community is not considered.
}
\details{
If the vector \code{x} is named, the names will be automatically
  used to match \code{x} with the tree. Missing names are filled in with
  zero counts. If \code{x} is not named and \code{x_labels} is provided,
  these labels are used to match the elements of \code{x} with the tree.
  If \code{x} is not named and \code{x_labels} is not provided, it is
  assumed that \code{x} is already in the correct order, and we simply
  check that its length matches the number of tips in the tree.
}
\examples{
# Faith's phylogenetic diversity for whole tree is equal to the sum of the
# branch lengths.
sum(faith_tree$edge.length)
faith_pd(c(1, 1, 1, 1, 1), faith_tree)

# Can use named vector or additional argument to match species to tree.
faith_tree$tip.label
faith_pd(c(0, 0, 0, 10, 12), faith_tree)
faith_pd(c(d=10, e=12), faith_tree)
faith_pd(c(10, 12), faith_tree, c("d", "e"))
}
\references{
Faith DP. Conservation evaluation and phylogenetic diversity.
  Biol. Conserv. 1992;61:1–10. doi: 10.1016/0006-3207(92)91201-3.
}
