% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.R
\name{margalef}
\alias{margalef}
\title{Margalef's richness index}
\usage{
margalef(x)
}
\arguments{
\item{x}{A numeric vector of species counts.}
}
\value{
The value of Margalef's index, \eqn{D \geq 0}. This index is
  undefined when the total number of counts is 1 or 0, in which case we
  return \code{NaN}.
}
\description{
Margalef's richness index
}
\details{
For a vector \code{x} of species counts, Margalef's index is
\deqn{D = \frac{S -1}{\log N},} where \eqn{S} is the total number of species
observed and \eqn{N} is the total number of counts.

This index is appropriate only for raw counts, not transformed counts or
proportions.

Equivalent to \code{margalef()} in \code{skbio.diversity.alpha}.
}
\examples{
x <- c(15, 6, 4, 0, 3, 0)
margalef(x)
}
\references{
Margalef R. Information theory in ecology. General Systems 3. 1958;36-71.
}
