% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_simulated_data.R
\name{generate_correlated_matrix}
\alias{generate_correlated_matrix}
\title{Generate a matrix of correlated variables}
\usage{
generate_correlated_matrix(n, p, corr, constant_cov_matrix = T, mean = 0)
}
\arguments{
\item{n}{number of observations}

\item{p}{number of features/variables}

\item{corr}{the correlation coefficient (-1 < r < 1)}

\item{constant_cov_matrix}{should the value of corr be constant in the covariance matrix, or should corr be the average value in the covariance matrix.}

\item{mean}{the mean value of the generated variables.}
}
\value{
an n x p matrix
}
\description{
Generate a matrix of correlated variables
}
\examples{
Subject <- generate_correlated_matrix(1, 100, corr = .75,constant_cov_matrix = TRUE)
Reference_Population <- generate_correlated_matrix(100, 100, corr = .75,constant_cov_matrix = TRUE)
}

