% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SZVD.R
\name{SZVD}
\alias{SZVD}
\alias{SZVD.default}
\title{Sparse Zero Variance Discriminant Analysis}
\usage{
SZVD(train, ...)

\method{SZVD}{default}(
  train,
  gamma,
  D,
  penalty = TRUE,
  scaling = TRUE,
  tol = list(abs = 1e-04, rel = 1e-04),
  maxits = 2000,
  beta = 1,
  quiet = TRUE,
  ...
)
}
\arguments{
\item{train}{Data matrix where first column is the response class.}

\item{...}{Parameters passed to SZVD.default.}

\item{gamma}{Set of regularization parameters controlling l1-penalty.}

\item{D}{dictionary/basis matrix.}

\item{penalty}{Controls whether to apply reweighting of l1-penalty (using sigma = within-class std devs).}

\item{scaling}{Logical indicating whether to scale data such that each
feature has variance 1.}

\item{tol}{Stopping tolerances for ADMM algorithm,
must include tol$rel and tol$abs.}

\item{maxits}{Maximum number of iterations used in the ADMM algorithm.}

\item{beta}{penalty term controlling the splitting constraint.}

\item{quiet}{Print intermediate outpur or not.}
}
\value{
\code{SZVD} returns an object of \code{\link{class}} "\code{SZVD}" including a list
with the following named components:

\describe{
  \item{\code{DVs}}{Discriminant vectors.}
  \item{\code{its}}{Number of iterations required to find DVs.}
  \item{\code{pen_scal}}{Weights used in reweighted l1-penalty.}
  \item{\code{N}}{Basis for the null-space of the sample within-class covariance.}
  \item{\code{means}}{Training class-means.}
  \item{\code{mus}}{Training meand and variance scaling/centering terms.}
  \item{\code{w0}}{unpenalized zero-variance discriminants (initial solutions) plus B and W, etc.}
}

\code{NULL}
}
\description{
Applies SZVD heuristic for sparse zero-variance discriminant
analysis to given training set.
}
\details{
This function will currently solve as a standalone function in accSDA for time comparison.
A wrapper function like ASDA will be created to use the functionality of plots and such.
Maybe call it ASZDA. For that purpose the individual ZVD function will need to be implemented.
}
\examples{
  set.seed(123)
  P <- 300 # Number of variables
  N <- 50 # Number of samples per class

  # Mean for classes, they are zero everywhere except the first 3 coordinates
  m1 <- rep(0,P)
  m1[1] <- 3

  m2 <- rep(0,P)
  m2[2] <- 3

  m3 <- rep(0,P)
  m3[3] <- 3

  # Sample dummy data
  Xtrain <- rbind(MASS::mvrnorm(n=N,mu = m1, Sigma = diag(P)),
                 MASS::mvrnorm(n=N,mu = m2, Sigma = diag(P)),
                MASS::mvrnorm(n=N,mu = m3, Sigma = diag(P)))


  # Generate the labels
  Ytrain <- rep(1:3,each=N)

  # Normalize the data
  Xt <- accSDA::normalize(Xtrain)
  Xtrain <- Xt$Xc

  # Train the classifier and increase the sparsity parameter from the default
  # so we penalize more for non-sparse solutions.
  res <- accSDA::SZVD(cbind(Ytrain,Xtrain),beta=2.5,
                     maxits=1000,tol = list(abs = 1e-04, rel = 1e-04))
}
\seealso{
Used by: \code{\link{SZVDcv}}.
}
