% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PerACF.R
\name{PerACF}
\alias{PerACF}
\title{Autocorrelation or autocovariance function estimation from the periodogram}
\usage{
PerACF(x, lag.max = NULL, type = c("correlation", "covariance"),
  plot = TRUE, na.action = na.fail, demean = TRUE, ...)
}
\arguments{
\item{x}{a numeric vector or matrix.}

\item{lag.max}{maximum lag at which to calculate the acf. Default is 10*log10(N/m) where
N is the number of observations and m the number of series. Will be automatically limited
to one less than the number of observations in the series.}

\item{type}{character string giving the type of acf to be computed. Allowed values are "correlation" (the default) or "covariance".
Accepts parcial names.}

\item{plot}{logical. If TRUE (the default) the acf is plotted.}

\item{na.action}{function to be called to handle missing values. na.pass can be used.}

\item{demean}{logical. Should the covariances be about the sample means?}

\item{...}{further arguments to be passed to plot.acf.}
}
\value{
An object of class "acf", which is a list with the following elements:

\code{lag} A three dimensional array containing the lags at which the acf is estimated.

\code{acf} An array with the same dimensions as lag containing the estimated acf.

\code{type} The type of correlation (same as the type argument).

\code{n.used} The number of observations in the time series.

\code{series} The name of the series x.

\code{snames} The series names for a multivariate time series.

The result is returned invisibly if plot is TRUE.
}
\description{
This function computer and plots(by default) the estimates of the autocovariance or the autocorrelation function for univariate and multivariate time series based
on the periodogram and the cross-periodogram..
}
\examples{
data.set <- cbind(fdeaths, mdeaths)
PerACF(data.set)
PerACF(data.set, type = "covariance", lag.max = 10)
}
\references{
Fuller, Wayne A. Introduction to statistical time series.  John Wiley & Sons, 2009.
}
\author{
Higor Cotta, Valderio Reisen, Pascal Bondon and Céline Lévy-Leduc. Part of the code re-used from the acf() function.
}
