% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm.R
\name{bdm}
\alias{bdm}
\title{Block Decomposition Method}
\usage{
bdm(
  string,
  blocksize = 10,
  alphabet = 9,
  delta = blocksize,
  print_blocks = FALSE
)
}
\arguments{
\item{string}{\code{character} vector containing the to be analyzed strings (can contain multiple strings).}

\item{blocksize}{size of blocks/substrings/windows to be created from \code{string}. Default is 10. Values larger than 10 will elicit a warning as not all strings with length > 10 are represented for all alphabets.}

\item{alphabet}{\code{numeric}, the number of possible symbols (not necessarily actually appearing in \code{string}). Must be one of \code{c(2, 4, 5, 6, 9)} (must be a scalar value in the current implementation). Default is 9.}

\item{delta}{distance between two blocks. Default is \code{delta = blocksize} (the maximum) in which the decomposition is disjoint, hence a partition (i.e., there is no overlap between blocks). In the default setting the last block is not of length \code{blocksize} if the length of the string is not divisible by \code{blocksize}. If \code{delta = 1} the blocks are all of length \code{blocksize} and maximally overlap.}

\item{print_blocks}{logical. Should blocks be printed to the console? Default is \code{FALSE}. Mainly for debugging purposes.}
}
\description{
Obtain Complexity of Longer Strings than allowed by ACSS via the Block Decomposition Method.
}
\examples{
acss("SSOOXFXFOXXOXOXFFXXXSOTTOFFFXX")  # too long

bdm("SSOOXFXFOXXOXOXFFXXXSOTTOFFFXX") # default blocksize is 10
bdm("SSOOXFXFOXXOXOXFFXXXSOTTOFFFXX", blocksize = 5)
bdm("SSOOXFXFOXXOXOXFFXXXSOTTOFFFXX", blocksize = 7) # gives warning
bdm("SSOOXFXFOXXOXOXFFXXXSOTTOFFFXX", blocksize = 7, delta = 1) 

multi <- c(
  "SSOOXFXFOXXOXOXFFXXXSOTTOFFFXX",
  "SSODXFXDOXXOXOXFFXRRSORTOXDOXX",
  "DXXXXRRXXXSSOOOXOFFFOOOOORFODD"
)

bdm(multi)
bdm(multi, delta = 1)
bdm(multi, blocksize = 5) 


# binary bdm should give 57.5664 in this case 
bdm("010101010101010101", alphabet = 2, blocksize = 12, delta = 1)

# show all blocks:
bdm("010101010101010101", alphabet = 2, blocksize = 12, delta = 1, print_blocks = TRUE)

# uses a block of size less than 12:
bdm("010101010101010101", alphabet = 2, blocksize = 6)

}
