% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frobenius_norm_funct_multiv_robust.R
\name{frobenius_norm_funct_multiv_robust}
\alias{frobenius_norm_funct_multiv_robust}
\title{Functional multivariate robust Frobenius norm}
\usage{
frobenius_norm_funct_multiv_robust(m, PM, prob, nbasis, nvars)
}
\arguments{
\item{m}{Data matrix with the residuals. This matrix has 
the same dimensions as the original data matrix.}

\item{PM}{Penalty matrix obtained with \code{\link[fda]{eval.penalty}}.}

\item{prob}{Probability with values in [0,1].}

\item{nbasis}{Number of basis.}

\item{nvars}{Number of variables.}
}
\value{
Real number.
}
\description{
Computes the functional multivariate robust Frobenius norm.
}
\details{
Residuals are vectors. If there are p variables (columns),
for every observation there is a residual that there is 
a p-dimensional vector. If there are n observations, the
residuals are an n times p matrix.
}
\examples{
mat <- matrix(1:400, ncol = 20)
PM <- matrix(1:100, ncol = 10)
frobenius_norm_funct_multiv_robust(mat, PM, 0.8, 10, 2)
                 
}
\references{
Moliner, J. and Epifanio, I., Robust multivariate and functional archetypal analysis 
with application to financial time series analysis, 2019. 
\emph{Physica A: Statistical Mechanics and its Applications} \bold{519}, 195-208. 
\url{https://doi.org/10.1016/j.physa.2018.12.036}
}
\author{
Irene Epifanio
}
