\name{adana-package}
\alias{adana-package}
\docType{package}
\title{Adaptive Nature-inspired Algorithms for Hybrid Genetic Optimization}

\description{
The package \pkg{adana} provides the functions related to the hyrid adaptive genetic algorithms for solving optimization problems.
}

\details{
The Genetic Algorithm (GA) is a type of optimization method of Evolutionary Algorithms. It uses the biologically inspired operators such as mutation, crossover, selection and replacement.Because of their global search and robustness abilities, GAs have been widely utilized in machine learning, expert systems, data science, engineering, life sciences and many other areas of research and business. However, the regular GAs need the techniques to improve their efficiences in computing time and performance in finding global optimum using some adaptation and hybridization strategies. The adaptive GAs (AGA) increase the convergence speed and success of regular GAs by setting the parameters crossover and mutation probabilities dynamically. The hybrid GAs combine the exploration strength of a stochastic GAs with the exact convergence ability of any type of deterministic local search algorithms such as simulated-annealing, in addition to other nature-inspired algorithms such as ant colony optimization, particle swarm optimization etc. The package 'adana' includes a rich working environment with its many functions that make possible to build and work regular GA, adaptive GA, hybrid GA and hybrid adaptive GA for any kind of optimization problems.
}

\references{
Cebeci, Z. (2021). R ile Genetik Algoritmalar ve Optimizasyon Uygulamalari [Genetic Algorithms and Optimization Applications with R], 535 p. Nobel Academic Publishing. Ankara
}

\author{Zeynel Cebeci, Erkut Tekeli}

\seealso{
\code{\link{adana}}
}

\keyword{ ~optimize}
\keyword{ ~graphs}

\concept{optimization}
\concept{evolutionary computing}
\concept{nature-inspired algorithms}
\concept{biologically inspired algorithms}
\concept{adaptive genetic algorithms}
\concept{hybrid genetic algorithms}

