% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt-wrappers.R
\name{adapt_glm}
\alias{adapt_glm}
\title{Adaptive P-value Thresholding with Generalized Linear Models}
\usage{
adapt_glm(x, pvals, pi_formulas, mu_formulas, dist = beta_family(),
  s0 = rep(0.45, length(pvals)), alphas = seq(0.01, 1, 0.01),
  piargs = list(), muargs = list(), ...)
}
\arguments{
\item{x}{covariates (i.e. side-information). Should be compatible to \code{models}. See Details}

\item{pvals}{a vector of values in [0, 1]. P-values}

\item{pi_formulas}{a vector/list of strings/formulas. Formulas for fitting pi(x) by glm. See Details}

\item{mu_formulas}{a vector/list of strings/formulas. Formulas for fitting mu(x) by glm. See Details}

\item{dist}{an object of class "\code{\link{gen_exp_family}}". \code{\link{beta_family}()} as default}

\item{s0}{a vector of values in [0, 0.5). Initial threshold.}

\item{alphas}{a vector of values in (0, 1). Target FDR levels.}

\item{piargs}{a list. Other arguments passed to glm for fitting pi(x)}

\item{muargs}{a list. Other arguments passed to glm for fitting mu(x)}

\item{...}{other arguments passed to \code{\link{adapt}} (except \code{models})}
}
\description{
\code{adapt_glm} is a wrapper of \code{\link{adapt}} that fits pi(x) and mu(x) by \code{\link[stats]{glm}}.
}
\details{
\code{pi_formulas} and \code{mu_formulas} can either be a list or a vector with each element being a string or a formula. For instance, suppose \code{x} has a single column with name \code{x1}, the following five options are valid for the same inputs (\code{\link[splines]{ns}} forms a spline basis with \code{df} knots):
\enumerate{
\item{c("x1", "ns(x1, df = 8)");}
\item{c("~ x1", "~ ns(x1, df = 8)");}
\item{list("x1", "ns(x1, df = 8)");}
\item{list("~ x1", "~ ns(x1, df = 8)");}
\item{list(~ x1, ~ ns(x1, df = 8))}
}
There is no need to specify the name of the response variable, as this is handled in the function.

When \code{x} has a few variables, it is common to use non-parametric GLM by replacing \code{x} by a spline basis of \code{x}. In this case, \code{\link[splines]{ns}} from \code{library(splines)} package is suggested.
}
\examples{
\donttest{
# Load estrogen data
data(estrogen)
pvals <- as.numeric(estrogen$pvals)
x <- data.frame(x = as.numeric(estrogen$ord_high))
dist <- beta_family()

# Subsample the data for convenience
inds <- (x$x <= 5000)
pvals <- pvals[inds]
x <- x[inds,,drop = FALSE]

# Run adapt_glm
library("splines")
formulas <- paste0("ns(x, df = ", 6:10, ")")
res <- adapt_glm(x = x, pvals = pvals, pi_formulas = formulas,
                 mu_formulas = formulas, dist = dist, nfits = 10)

# Run adapt by manually setting models for glm
models <- lapply(formulas, function(formula){
    piargs <- muargs <- list(formula = formula)
    gen_adapt_model(name = "glm", piargs = piargs, muargs = muargs)
})
res2 <- adapt(x = x, pvals = pvals, models = models,
              dist = dist, nfits = 10)

# Check equivalence
identical(res, res2)
}

}
\seealso{
\code{\link{adapt}}, \code{\link{adapt_gam}}, \code{\link{adapt_glmnet}}, \code{\link[stats]{glm}}, \code{\link[splines]{ns}}
}
