% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_advs_params.R
\name{derive_param_waisthip}
\alias{derive_param_waisthip}
\title{Adds a Parameter for Waist to Hip Ratio}
\usage{
derive_param_waisthip(
  dataset,
  by_vars,
  wstcir_code = "WSTCIR",
  hipcir_code = "HIPCIR",
  set_values_to = exprs(PARAMCD = "WAISTHIP"),
  filter = NULL,
  get_unit_expr
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected to be in the dataset.
\code{PARAMCD}, and \code{AVAL} are expected as well.

The variable specified by \code{by_vars} and \code{PARAMCD} must be a unique key of the input dataset
after restricting it by the filter condition (\code{filter} argument) and to the parameters
specified by \code{wstcir_code} and \code{hipcir_code}.}

\item{by_vars}{Grouping variables

Grouping variables uniquely identifying a set of records for which
\code{new_vars} are to be calculated.

\emph{Permitted Values:} list of variables created by exprs()}

\item{wstcir_code}{Waist Circumference parameter code

The observations where \code{PARAMCD} equals the specified value are considered
as the Waist Circumference.

\emph{Permitted Values:} character value}

\item{hipcir_code}{Hip Circumference parameter code

The observations where \code{PARAMCD} equals the specified value are considered
as the Hip Circumference

\emph{Permitted Values:} character value}

\item{set_values_to}{Variables to be set

The specified variables are set to the specified values for the new
observations. For example \code{exprs(PARAMCD = "RATIO")} defines the parameter code
for the new parameter.

\emph{Permitted Values:} List of variable-value pairs}

\item{filter}{Filter condition

The specified condition is applied to the input dataset before deriving the
new parameter, i.e., only observations fulfilling the condition are taken
into account.

\emph{Permitted Values:} a condition}

\item{get_unit_expr}{An expression providing the unit of the parameter

The result is used to check the units of the input parameters. If the units are not consistent
within each parameter, an error will be thrown.

Additionally, if the input parameters are measured in different units but are mutually
convertible (e.g., centimeters for one parameter and inches for another), an automatic
conversion will be performed in order to uniform the values before calculating the ratio.

\strong{Note:} Conversion factors come from unit definitions as per CDISC standards.
\if{html}{\out{<br/>}}\emph{m} is defined as 100 cm
\if{html}{\out{<br/>}}\emph{mm} is defined as 0.1 cm
\if{html}{\out{<br/>}}\emph{in} is defined as 2.54 cm
\if{html}{\out{<br/>}}\emph{ft} is defined as 30.48 cm

\emph{Permitted Values:} A variable of the input dataset or a function call}
}
\value{
The input dataset with the new parameter added. Note, a variable will only
be populated in the new parameter rows if it is specified in \code{by_vars}.
}
\description{
Adds a parameter for Waist to Hip Ratio using Waist Circumference and
Hip Circumference for each by group (e.g., subject and visit) where the source parameters
are available.

\strong{Note:} This is a wrapper function for the more generic \code{\link[admiral:derive_param_computed]{admiral::derive_param_computed()}}.
}
\details{
The analysis value of the new parameter is derived as
\deqn{WAISTHIP = \frac{WSTCIR}{HIPCIR}}{WAISTHIP = WSTCIR / HIPCIR}
}
\examples{
library(tibble)
library(rlang)

advs <- tribble(
  ~USUBJID, ~PARAMCD, ~PARAM, ~AVAL, ~AVALU, ~VISIT,
  "01-101-1001", "WSTCIR", "Waist Circumference (cm)", 110, "cm", "SCREENING",
  "01-101-1001", "WSTCIR", "Waist Circumference (cm)", 108, "cm", "WEEK 2",
  "01-101-1001", "WSTCIR", "Waist Circumference (cm)", 107, "cm", "WEEK 3",
  "01-101-1001", "HIPCIR", "Hip Circumference (cm)", 125, "cm", "SCREENING",
  "01-101-1001", "HIPCIR", "Hip Circumference (cm)", 124, "cm", "WEEK 2",
  "01-101-1001", "HIPCIR", "Hip Circumference (cm)", 123, "cm", "WEEK 3",
  "01-101-1002", "WSTCIR", "Waist Circumference (cm)", 120, "cm", "SCREENING",
  "01-101-1002", "WSTCIR", "Waist Circumference (cm)", 118, "cm", "WEEK 2",
  "01-101-1002", "WSTCIR", "Waist Circumference (cm)", 117, "cm", "WEEK 3",
  "01-101-1002", "HIPCIR", "Hip Circumference (cm)", 135, "cm", "SCREENING",
  "01-101-1002", "HIPCIR", "Hip Circumference (cm)", 133, "cm", "WEEK 2",
  "01-101-1002", "HIPCIR", "Hip Circumference (cm)", 132, "cm", "WEEK 3"
)

derive_param_waisthip(
  advs,
  by_vars = exprs(USUBJID, VISIT),
  wstcir_code = "WSTCIR",
  hipcir_code = "HIPCIR",
  set_values_to = exprs(
    PARAMCD = "WAISTHIP",
    PARAM = "Waist to Hip Ratio"
  ),
  get_unit_expr = admiral::extract_unit(PARAM)
)

# Only adding Waist to Hip Ratio at certain visits

derive_param_waisthip(
  advs,
  by_vars = exprs(USUBJID, VISIT),
  wstcir_code = "WSTCIR",
  hipcir_code = "HIPCIR",
  set_values_to = exprs(
    PARAMCD = "WAISTHIP",
    PARAM = "Waist to Hip Ratio"
  ),
  get_unit_expr = admiral::extract_unit(PARAM),
  filter = VISIT \%in\% c("SCREENING", "WEEK 3")
)

# Automatic conversion is performed when deriving the ratio
# if parameters are provided in different units

advs <- tribble(
  ~USUBJID, ~PARAMCD, ~PARAM, ~AVAL, ~AVALU, ~VISIT,
  "01-101-1001", "HIPCIR", "Hip Circumference (cm)", 125, "cm", "SCREENING",
  "01-101-1001", "HIPCIR", "Hip Circumference (cm)", 124, "cm", "WEEK 2",
  "01-101-1001", "HIPCIR", "Hip Circumference (cm)", 123, "cm", "WEEK 3",
  "01-101-1001", "WSTCIR", "Waist Circumference (in)", 43.31, "in", "SCREENING",
  "01-101-1001", "WSTCIR", "Waist Circumference (in)", 42.52, "in", "WEEK 2",
  "01-101-1001", "WSTCIR", "Waist Circumference (in)", 42.13, "in", "WEEK 3",
  "01-101-1002", "HIPCIR", "Hip Circumference (cm)", 135, "cm", "SCREENING",
  "01-101-1002", "HIPCIR", "Hip Circumference (cm)", 133, "cm", "WEEK 2",
  "01-101-1002", "HIPCIR", "Hip Circumference (cm)", 132, "cm", "WEEK 3",
  "01-101-1002", "WSTCIR", "Waist Circumference (in)", 47.24, "in", "SCREENING",
  "01-101-1002", "WSTCIR", "Waist Circumference (in)", 46.46, "in", "WEEK 2",
  "01-101-1002", "WSTCIR", "Waist Circumference (in)", 46.06, "in", "WEEK 3"
)

derive_param_waisthip(
  advs,
  by_vars = exprs(USUBJID, VISIT),
  wstcir_code = "WSTCIR",
  hipcir_code = "HIPCIR",
  set_values_to = exprs(
    PARAMCD = "WAISTHIP",
    PARAM = "Waist to Hip Ratio"
  ),
  get_unit_expr = admiral::extract_unit(PARAM)
)
}
\seealso{
\code{\link[admiral:derive_param_computed]{admiral::derive_param_computed()}}

ADVS Functions for adding Parameters:
\code{\link{derive_param_waisthgt}()}
}
\concept{der_prm_advs}
\keyword{der_prm_advs}
