% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_process_reacto.R
\name{post_process_reacto}
\alias{post_process_reacto}
\title{Post processing function for ADFACE dataset}
\usage{
post_process_reacto(
  dataset,
  filter_dataset = FATESTCD \%in\% c("MAXDIAM", "MAXSEV", "MAXTEMP") | (FATESTCD ==
    "OCCUR" & FAOBJ == "FEVER")
)
}
\arguments{
\item{dataset}{Input dataset}

\item{filter_dataset}{Filter condition
Conversion of records in FA variables to NA depends on this condition.}
}
\value{
The input dataframe with \code{NA} values in FA variables where the SDTM records modified for
ADaM derivation purpose.
}
\description{
This is used to do post processing for ADaM reactogenicity dataset, for the derived
SDTM level records, the corresponding values in FA variables will be \code{NA}.
}
\examples{
library(dplyr)
library(admiral)
library(tibble)

input <- tribble(
  ~USUBJID, ~FAOBJ, ~FALAT, ~FACAT, ~FASCAT, ~FATPT, ~FATESTCD, ~PARAMCD, ~AVAL,
  "ABC-1001", "FEVER", NA, "REACTO", "SYS", "DAY 1", "MAXTEMP", "MAXTEMP", 39.4,
  "ABC-1001", "VOMITING", NA, "REACTO", "SYS", "DAY 4", "MAXSEV", "MAXVOMIT", 3,
  "ABC-1001", "SWELLING", "LEFT", "REACTO", "ADMIN", "DAY 1", "MAXSEV", "MAXSWEL", 3,
  "ABC-1001", "REDNESS", "LEFT", "REACTO", "ADMIN", "DAY 2", "DIAMATER", "DIARE", 10.3,
  "ABC-1001", "FEVER", "LEFT", "REACTO", "SYS", "DAY 2", "OCCUR", "OCCFEV", NA
)

post_process_reacto(
  dataset = input,
  filter_dataset = FATESTCD \%in\% c("MAXSEV", "MAXTEMP") |
    (FATESTCD == "OCCUR" & FAOBJ == "FEVER")
)

}
\author{
Arjun Rubalingam
}
\concept{other_advanced}
\keyword{other_advanced}
