% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm_validate.R
\name{cm_val}
\alias{cm_val}
\title{Validate the definition of a Calculated Metric}
\usage{
cm_val(
  definition = NULL,
  locale = "en_US",
  migrating = FALSE,
  debug = FALSE,
  rsid = Sys.getenv("AW_REPORTSUITE_ID"),
  company_id = Sys.getenv("AW_COMPANY_ID")
)
}
\arguments{
\item{definition}{json string definition of a calculated metric}

\item{locale}{The location of the language. en-US is default.}

\item{migrating}{Include migration functions in validation. FALSE is default.}

\item{debug}{This enables the api call information to show in the console for
help with debugging issues. default is FALSE}

\item{rsid}{Adobe report suite ID (RSID).  If an environment variable called
\code{AW_REPORTSUITE_ID} exists in \code{.Renviron} or elsewhere and no \code{rsid} argument
is provided, then the \code{AW_REPORTSUITE_ID} value will be used. Use \code{\link[=aw_get_reportsuites]{aw_get_reportsuites()}}
to get a list of available \code{rsid} values.}

\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID}
exists in \code{.Renviron} or elsewhere and no \code{company_id} argument is provided,
then the \code{AW_COMPANY_ID} value will be used. Use \code{\link[=get_me]{get_me()}} to get a list of
available \code{company_id} values.}
}
\value{
A string confirming the calculated metric is valid or is not valid.
}
\description{
This function checks if a calculated metric JSON string is valid
}
\details{
See more information \href{https://experienceleague.adobe.com/en/docs/analytics/components/calculated-metrics/calcmetric-workflow/cm-build-metrics}{here}
}
