% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_starts.R
\name{get_random}
\alias{get_random}
\title{Generate initial random start}
\usage{
get_random(data, nclusters, seed = NULL)
}
\arguments{
\item{data}{Object-by-variable data matrix of class \code{matrix} or
\code{data.frame}.}

\item{nclusters}{Number of clusters to be used. Must be a positive integer.}

\item{seed}{Integer. Seed for the random number generator. Default: NULL}
}
\value{
\code{get_random()} returns a list with the following components:
  \describe{ \item{\code{type}}{A character string denoting the type of start
  ('Random Start')} \item{\code{A}}{A randomly generated initial Membership
  matrix}}
}
\description{
Generate an initial random start for the (low dimensional) Additive Profile
Clustering algorithm (see \code{\link{adproclus}} and
\code{\link{adproclus_low_dim}}).
}
\details{
\code{get_random} generates a random initial binary membership matrix
\strong{A} such that each entry is an independen draw from a
Bernoulli Distribution with \eqn{\pi = 0.5}.

For generating an initial start from random draws from the data, see
\code{\link{get_semirandom}}.
For generating an initial start based on a specific set of initial cluster
centers, see \code{\link{get_rational}}.

\strong{Warning:} This function does \emph{not} obtain an ADPRCOLUS model.
To perform aditive profile clustering, see \code{\link{adproclus}}.
}
\examples{
# Obtain data from data set "Stackloss" and generate start allocation
start_allocation <- get_random(stackloss, 3)$A

}
\references{
Wilderjans, T. F., Ceulemans, E., Van Mechelen, I., & Depril, D.
(2010). ADPROCLUS: a graphical user interface for fitting additive profile
clustering models to object by variable data matrices. \emph{Behavior
Research Methods, 43}(1), 56-65.

Depril, D., Van Mechelen, I., & Mirkin, B.
(2008). Algorithms for additive clustering of rectangular data tables.
\emph{Computational Statistics and Data Analysis, 52,} 4923-4938.

Depril, D., Van Mechelen, I., & Wilderjans, T. F.
(2012). Lowdimensional additive overlapping clustering.
\emph{Journal of classification, 29,} 297-320.
}
\seealso{
\describe{
  \item{\code{\link{adproclus}}, \code{\link{adproclus_low_dim}}}{for details
   about membership and profile matrices}
  \item{\code{\link{get_semirandom}}}{for generating semi-random starts}
  \item{\code{\link{get_rational}}}{for generating rational starts}
}
}
