\name{agree.ccc}
\title{Concordance Correlation Coefficient}
\alias{agree.ccc}
\alias{ccc.mm}
\alias{ccc.lognormalNormal.mcmc}
\alias{ccc.mvn.mcmc}
\alias{ccc.mvt.mcmc}
\alias{ccc.nonpara.jackknife}
\alias{ccc.nonpara.bootstrap}
\description{
  Obtain confidence interval and point estimate of the
  concordance correlation coefficient (CCC) proposed in Lin (1989).
}
\usage{
  agree.ccc(ratings, conf.level=0.95,
            method=c("jackknifeZ", "jackknife",
                     "bootstrap","bootstrapBC",
                     "mvn.jeffreys", "mvn.conjugate",
                     "mvt", "lognormalNormal", "mvsn", "mvst"),
            nboot=999, nmcmc=10000,
            mvt.para=list(prior=list(lower.v=4, upper.v=25,
                                     Mu0=rep(0, ncol(ratings)),
                                     Sigma0=diag(10000, ncol(ratings)),
                                     p=ncol(ratings),
                                     V=diag(1, ncol(ratings))),
                          initial=list(v=NULL, Sigma=NULL)),
            NAaction=c("fail", "omit"))
}
\arguments{
  \item{ratings}{a matrix of observations with one subject per row and one
	rater per column.}
  \item{conf.level}{confidence level of the interval. The default
	is 0.95.}
  \item{method}{a character string specifying the method used to
	obtain the estimate of the CCC.
    It must be one of "jackknifeZ", "jackknife", "bootstrap",
	"bootstrapBC", "mvn.jeffreys", "mvn.conjugate","mvt",
	"lognormalNormal", "mvsn", and "mvst". It can be abbreviated. The default is "jackknifeZ".}
  \item{nboot}{number of bootstrap replicates. The default value is 999.}
  \item{nmcmc}{number of iterations used in the Bayesian approach. The
	default value is 10000.}
  \item{mvt.para}{values of hyper-parameters and initial values of
	parameters for multivariate t (MVT) distribution.
	\code{lower.v} is the lower bound of degrees of freedom (df) of the MVT.
    \code{upper.v} is the upper bound of df of the MVT.
    \code{Mu0} is the mean vector of multivariate normal prior of the
	location of the MVT and the default value is 0.
    \code{Sigma0} is the variance matrix of multivariate normal prior of
	the location of the MVT and the default value is a diagonal matrix with
	diagonal entries equal to 10000.
    \code{p} is the df of wishart prior of inverse of the scale matrix
	of the MVT and the default value is the number of raters.
    \code{V} is the scale matrix of wishart prior of inverse of the scale
	matrix of the MVT and the default value is identity matrix.
    \code{v} is the initial value of the df of the MVT. Its default is
	\code{NULL} and for the default, the value will be generated by using
	the ECME Algorithm.
    \code{Sigma} is the initial value of the scale matrix of the MVT.
	Its default is \code{NULL} and for the default, the value will be
	generated by using the ECME Algorithm.}
  \item{NAaction}{a character string specifying what should happen
	when the data contain \code{NA}s. It must be one of "fail"
	and "omit" and may be abbreviated. The default is "fail" that causes
	the function to print an error message and terminate if there are
	any incomplete observations. If it is "omit", then the entire row(s)
	containing incomplete observation(s) will be deleted.}

}
\details{
  To obtain point estimate and confidence interval, the methods available include the
  jackknife method with and without Z-transformation, the bootstrap,
  and the Bayesian approach for the multivariate normal, multivariate
  t, lognormal-normal, multivariate skew normal, and multivariate skew t distributions.
}
\value{
    Point estimate and lower and upper bounds of the confidence
    interval of the CCC. 
}
\references{
  Dai Feng, Richard Baumgartner and Vladimir Svetnik (2016)
  Estimating the concordance correlation coefficient using a unified Bayesian framework
  \emph{under review}
  
  Dai Feng, Richard Baumgartner and Vladimir Svetnik (2015)
  A Bayesian estimate of the concordance correlation coefficient with skewed data.
  \emph{Pharmaceutical Statistics},
  DOI: 10.1002/pst.1692

  Dai Feng, Richard Baumgartner and Vladimir Svetnik (2015)
  A robust Bayesian estimate of the concordance correlation coefficient.
  \emph{Journal of Biopharmaceutical Statistics} \bold{25(3)} 490-507,
  DOI: 10.1080/10543406.2014.920342

  Dai Feng, Vladimir Svetnik, Alexandre Coimbra and Richard Baumgartner (2014)
  A comparison of confidence interval methods for the concordance
  correlation coefficient and intraclass correlation coefficient with
  small number of raters.
  \emph{Journal of Biopharmaceutical Statistics} \bold{24(2)} 272-293,
  DOI: 10.1080/10543406.2013.863780.

  Dai Feng,  Richard Baumgartner and Vladimir Svetnik (2014)
  A short note on jackknifing the concordance correlation coefficient.
  \emph{Statistics in Medicine} \bold{33(3)} 514-516, DOI: 10.1002/sim.5931
 

  Lawrence I-Kuei Lin (1989)
  A concordance correlation coefficient to evaluate reproducibility.
  \emph{Biometrics} \bold{45} 255-268

} 
\seealso{
  \code{\link[epiR]{epi.ccc}}, \code{\link[cccrm]{cccvc}},
  \code{\link[miscF]{mvt.ecme}}
}
\examples{
  data(judgeRatings)
  agree.ccc(judgeRatings[,2:3])
}
\keyword{htest}



