% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-dummies.R
\name{getUDummyMatForOneVec}
\alias{getUDummyMatForOneVec}
\title{Create a U-dummy matrix for one variable}
\usage{
getUDummyMatForOneVec(
  x_vec,
  levels = NULL,
  drop_last = TRUE,
  only_info = FALSE
)
}
\arguments{
\item{x_vec}{A vector representing original variable.
The class of \code{x_vec} should be one of \code{integer}, \code{character}, or \code{factor}.}

\item{levels}{A character vector representing values of \code{x_vec} used to create U-dummies.
If \code{NULL}, all the unique values of \code{x_vec} are used to create dummies.}

\item{drop_last}{If \code{TRUE}, the last column of the resulting matrix is dropped to avoid multicollinearity.}

\item{only_info}{If \code{TRUE}, only information fields of returned values are filled and no dummy matrix is returned.}
}
\value{
A list with the following fields:
\itemize{
\item \code{levels}: Same as input.
\item \code{drop_last}: Same as input.
\item \code{dummy_mat}: The created U-dummy matrix (only if \code{only_info=FALSE}).
}
}
\description{
Create a U-dummy matrix for one variable
}
\author{
Kenji Kondo
}
