% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_S3_methods.R
\name{plot.metAgri}
\alias{plot.metAgri}
\title{Plot an object of class \code{metAgri}}
\usage{
\method{plot}{metAgri}(
  x,
  type = c("correlation", "covariance", "multi_traits"),
  filter_traits = NULL,
  text_size = 4,
  ...
)
}
\arguments{
\item{x}{An object inheriting from class \code{metAgri} resulting of
executing the function \code{met_analysis()}}

\item{type}{A character string specifying the type of plot. "correlation",
"covariance" or "multi_traits"}

\item{filter_traits}{An optional character vector to filter traits.}

\item{text_size}{Numeric input to define the text size.}

\item{...}{Further graphical parameters passed to \code{covcor_heat()}.}
}
\value{
A ggplot object.
}
\description{
Create several plots for an object of class \code{metAgri}
}
\examples{
\dontrun{
library(agridat)
library(agriutilities)
data(besag.met)
dat <- besag.met
results <- check_design_met(
  data = dat,
  genotype = "gen",
  trial = "county",
  traits = c("yield"),
  rep = "rep",
  block = "block",
  col = "col",
  row = "row"
)
out <- single_trial_analysis(results, progress = FALSE)
met_results <- met_analysis(out, progress = FALSE)
print(met_results)
plot(met_results, type = "correlation")
plot(met_results, type = "covariance")
}
}
\author{
Johan Aparicio [aut]
}
