% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{NVCAdata}
\alias{NVCAdata}
\title{Interim Dane data with new violent criminal activity (NVCA) as an outcome}
\format{
A data frame with 1891 rows and 19 variables:
\describe{
  \item{Z}{binary treatment}
  \item{D}{ordinal decision}
  \item{Y}{outcome}
  \item{Sex}{male or female}
  \item{White}{white or non-white}
  \item{SexWhite}{the interaction between gender and race}
  \item{Age}{age}
  \item{PendingChargeAtTimeOfOffense}{binary variable for pending charge (felony, misdemeanor, or both) at the time of offense}
  \item{NCorNonViolentMisdemeanorCharge}{binary variable for current non-violent felony charge}
  \item{ViolentMisdemeanorCharge}{binary variable for current violent misdemeanor charge}
  \item{ViolentFelonyCharge}{binary variable for current violent felony charge}
  \item{NonViolentFelonyCharge}{binary variable for current non-violent felony charge}
  \item{PriorMisdemeanorConviction}{binary variable for prior conviction of misdemeanor}
  \item{PriorFelonyConviction}{binary variable for prior conviction of felony}
  \item{PriorViolentConviction}{four-level ordinal variable for prior violent conviction}
  \item{PriorSentenceToIncarceration}{binary variable for prior sentence to incarceration}
  \item{PriorFTAInPast2Years}{three-level ordinal variable for FTAs from past two years}
  \item{PriorFTAOlderThan2Years}{binary variable for FTAs from over two years ago}
  \item{Staff_ReleaseRecommendation}{four-level ordinal variable for the DMF recommendation}
}
}
\usage{
NVCAdata
}
\description{
An interim dataset containing pre-treatment covariates, a binary treatment (Z), an ordinal decision (D),
and an outcome variable (Y). The data used for the paper, and made available here, are interim, based on
only half of the observations in the study and (for those observations) only half of the study follow-up period.
We use them only to illustrate methods, not to draw substantive conclusions.
}
\keyword{datasets}
