% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateInputsModel.GRiwrm.R
\name{CreateInputsModel.GRiwrm}
\alias{CreateInputsModel.GRiwrm}
\title{Creation of an InputsModel object for a \strong{airGRiwrm} network}
\usage{
\method{CreateInputsModel}{GRiwrm}(
  x,
  DatesR,
  Precip = NULL,
  PotEvap = NULL,
  Qinf = NULL,
  Qobs = NULL,
  Qmin = NULL,
  Qrelease = NULL,
  PrecipScale = TRUE,
  TempMean = NULL,
  TempMin = NULL,
  TempMax = NULL,
  ZInputs = NULL,
  HypsoData = NULL,
  NLayers = 5,
  IsHyst = FALSE,
  ...
)
}
\arguments{
\item{x}{[GRiwrm object] diagram of the semi-distributed model (See \link{CreateGRiwrm})}

\item{DatesR}{\link{POSIXt} vector of dates}

\item{Precip}{(optional) \link{matrix} or \link{data.frame} of \link{numeric} containing
precipitation in [mm per time step]. Column names correspond to node IDs}

\item{PotEvap}{(optional) \link{matrix} or \link{data.frame} of \link{numeric} containing
potential evaporation [mm per time step]. Column names correspond to node IDs}

\item{Qinf}{(optional) \link{matrix} or \link{data.frame} of \link{numeric} containing
observed flows. It must be provided only for nodes of type "Direct
injection" and "Diversion". See \link{CreateGRiwrm} for
details about these node types. Unit is [mm per time step] for nodes
with an area, and [m3 per time step] for nodes with \code{area=NA}.
Column names correspond to node IDs. Negative flows are abstracted from
the model and positive flows are injected to the model}

\item{Qobs}{(deprecated) use \code{Qinf} instead}

\item{Qmin}{(optional) \link{matrix} or \link{data.frame} of \link{numeric} containing
minimum flows to let downstream of a node with a Diversion [m3 per
time step]. Default is zero. Column names correspond to node IDs}

\item{Qrelease}{(optional) \link{matrix} or \link{data.frame} of \link{numeric} containing
release flows by nodes using the model \code{RunModel_Reservoir} [m3 per
time step]}

\item{PrecipScale}{(optional) named \link{vector} of \link{logical} indicating if the
mean of the precipitation interpolated on the elevation layers must be
kept or not, required to create CemaNeige module inputs, default \code{TRUE}
(the mean of the precipitation is kept to the original value)}

\item{TempMean}{(optional) \link{matrix} or \link{data.frame} of time series of mean
air temperature [°C], required to create the CemaNeige module inputs}

\item{TempMin}{(optional) \link{matrix} or \link{data.frame} of time series of minimum
air temperature [°C], possibly used to create the CemaNeige module inputs}

\item{TempMax}{(optional) \link{matrix} or \link{data.frame} of time series of maximum
air temperature [°C], possibly used to create the CemaNeige module inputs}

\item{ZInputs}{(optional) named \link{vector} of \link{numeric} giving the mean
elevation of the Precip and Temp series (before extrapolation) [m],
possibly used to create the CemaNeige module input}

\item{HypsoData}{(optional) \link{matrix} or \link{data.frame} containing 101 \link{numeric}
rows: min, q01 to q99 and max of catchment elevation distribution [m],
if not defined a single elevation is used for CemaNeige}

\item{NLayers}{(optional) named \link{vector} of \link{numeric} integer giving the number
of elevation layers requested \link{-}, required to create CemaNeige module
inputs, default=5}

\item{IsHyst}{\link{logical} boolean indicating if the hysteresis version of
CemaNeige is used. See details of \link[airGR:CreateRunOptions]{airGR::CreateRunOptions}.}

\item{...}{used for compatibility with S3 methods}
}
\value{
A \emph{GRiwrmInputsModel} object which is a list of \emph{InputsModel}
objects created by \link[airGR:CreateInputsModel]{airGR::CreateInputsModel} with one item per modeled sub-catchment.
}
\description{
Creation of an InputsModel object for a \strong{airGRiwrm} network
}
\details{
Meteorological data are needed for the nodes of the network that
represent a catchment simulated by a rainfall-runoff model. Instead of
\link[airGR:CreateInputsModel]{airGR::CreateInputsModel} that has \link{numeric} \link{vector} as time series inputs,
this function uses \link{matrix} or \link{data.frame} with the id of the sub-catchment
as column names. For single values (\code{ZInputs} or \code{NLayers}), the function
requires named \link{vector} with the id of the sub-catchment as name item. If an
argument is optional, only the column or the named item has to be provided.

See \link[airGR:CreateInputsModel]{airGR::CreateInputsModel} documentation for details concerning each input.

Number of rows of \code{Precip}, \code{PotEvap}, \code{Qinf}, \code{Qmin}, \code{TempMean}, \code{TempMin},
\code{TempMax} must be the same of the length of \code{DatesR} (each row corresponds to
a time step defined in \code{DatesR}).

For examples of use see topics \link{RunModel.GRiwrmInputsModel}, \link{RunModel_Reservoir},
and \link{RunModel.Supervisor}.

For example of use of Direct Injection nodes, see vignettes
"V03_Open-loop_influenced_flow" and "V04_Closed-loop_regulated_withdrawal".

For example of use of Diversion nodes, see example in
\link{RunModel.GRiwrmInputsModel} topic and vignette
"V06_Modelling_regulated_diversion".
}
\seealso{
\code{\link[=CreateGRiwrm]{CreateGRiwrm()}}, \code{\link[=CreateRunOptions]{CreateRunOptions()}}, \code{\link[=RunModel.GRiwrmInputsModel]{RunModel.GRiwrmInputsModel()}}
}
